/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.Amount;
import com.adyen.model.binlookup.CostEstimateAssumptions;
import com.adyen.model.binlookup.JSON;
import com.adyen.model.binlookup.MerchantDetails;
import com.adyen.model.binlookup.Recurring;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "assumptions", "cardNumber", "encryptedCardNumber", "merchantAccount", "merchantDetails", "recurring", "selectedRecurringDetailReference", "shopperInteraction", "shopperReference"})
public class CostEstimateRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_ASSUMPTIONS = "assumptions";
    private CostEstimateAssumptions assumptions;
    public static final String JSON_PROPERTY_CARD_NUMBER = "cardNumber";
    private String cardNumber;
    public static final String JSON_PROPERTY_ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
    private String encryptedCardNumber;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_DETAILS = "merchantDetails";
    private MerchantDetails merchantDetails;
    public static final String JSON_PROPERTY_RECURRING = "recurring";
    private Recurring recurring;
    public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    private String selectedRecurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;

    public CostEstimateRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CostEstimateRequest assumptions(CostEstimateAssumptions assumptions) {
        this.assumptions = assumptions;
        return this;
    }

    @JsonProperty(value="assumptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CostEstimateAssumptions getAssumptions() {
        return this.assumptions;
    }

    @JsonProperty(value="assumptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssumptions(CostEstimateAssumptions assumptions) {
        this.assumptions = assumptions;
    }

    public CostEstimateRequest cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardNumber() {
        return this.cardNumber;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public CostEstimateRequest encryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
        return this;
    }

    @JsonProperty(value="encryptedCardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedCardNumber() {
        return this.encryptedCardNumber;
    }

    @JsonProperty(value="encryptedCardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    public CostEstimateRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CostEstimateRequest merchantDetails(MerchantDetails merchantDetails) {
        this.merchantDetails = merchantDetails;
        return this;
    }

    @JsonProperty(value="merchantDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantDetails getMerchantDetails() {
        return this.merchantDetails;
    }

    @JsonProperty(value="merchantDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantDetails(MerchantDetails merchantDetails) {
        this.merchantDetails = merchantDetails;
    }

    public CostEstimateRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Recurring getRecurring() {
        return this.recurring;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public CostEstimateRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return this;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public CostEstimateRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public CostEstimateRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CostEstimateRequest costEstimateRequest = (CostEstimateRequest)o;
        return Objects.equals(this.amount, costEstimateRequest.amount) && Objects.equals(this.assumptions, costEstimateRequest.assumptions) && Objects.equals(this.cardNumber, costEstimateRequest.cardNumber) && Objects.equals(this.encryptedCardNumber, costEstimateRequest.encryptedCardNumber) && Objects.equals(this.merchantAccount, costEstimateRequest.merchantAccount) && Objects.equals(this.merchantDetails, costEstimateRequest.merchantDetails) && Objects.equals(this.recurring, costEstimateRequest.recurring) && Objects.equals(this.selectedRecurringDetailReference, costEstimateRequest.selectedRecurringDetailReference) && Objects.equals((Object)this.shopperInteraction, (Object)costEstimateRequest.shopperInteraction) && Objects.equals(this.shopperReference, costEstimateRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.assumptions, this.cardNumber, this.encryptedCardNumber, this.merchantAccount, this.merchantDetails, this.recurring, this.selectedRecurringDetailReference, this.shopperInteraction, this.shopperReference});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CostEstimateRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    assumptions: ").append(this.toIndentedString(this.assumptions)).append("\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    encryptedCardNumber: ").append(this.toIndentedString(this.encryptedCardNumber)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantDetails: ").append(this.toIndentedString(this.merchantDetails)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CostEstimateRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CostEstimateRequest)JSON.getMapper().readValue(jsonString, CostEstimateRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE(String.valueOf("Ecommerce")),
        CONTAUTH(String.valueOf("ContAuth")),
        MOTO(String.valueOf("Moto")),
        POS(String.valueOf("POS"));

        private static final Logger LOG;
        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ShopperInteractionEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ShopperInteractionEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ShopperInteractionEnum.class.getName());
        }
    }
}

