/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"action", "reason", "schedule"})
public class UpdatePayoutScheduleRequest {
    public static final String JSON_PROPERTY_ACTION = "action";
    private ActionEnum action;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private ScheduleEnum schedule;

    public UpdatePayoutScheduleRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(value="Direction on how to handle any payouts that have already been scheduled. Permitted values: * `CLOSE` will close the existing batch of payouts. * `UPDATE` will reschedule the existing batch to the new schedule. * `NOTHING` (**default**) will allow the payout to proceed.")
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActionEnum getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public UpdatePayoutScheduleRequest reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the payout schedule update. > This field is required when the `schedule` parameter is set to `HOLD`.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public UpdatePayoutScheduleRequest schedule(ScheduleEnum schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="The payout schedule to which the account is to be updated. Permitted values: `DAILY`, `DAILY_US`, `DAILY_EU`, `DAILY_AU`, `DAILY_SG`, `WEEKLY`, `WEEKLY_ON_TUE_FRI_MIDNIGHT`, `BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT`, `MONTHLY`, `HOLD`. `HOLD` will prevent scheduled payouts from happening but will still allow manual payouts to occur.")
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScheduleEnum getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchedule(ScheduleEnum schedule) {
        this.schedule = schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatePayoutScheduleRequest updatePayoutScheduleRequest = (UpdatePayoutScheduleRequest)o;
        return Objects.equals((Object)this.action, (Object)updatePayoutScheduleRequest.action) && Objects.equals(this.reason, updatePayoutScheduleRequest.reason) && Objects.equals((Object)this.schedule, (Object)updatePayoutScheduleRequest.schedule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.reason, this.schedule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdatePayoutScheduleRequest {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString((Object)this.schedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdatePayoutScheduleRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdatePayoutScheduleRequest)JSON.getMapper().readValue(jsonString, UpdatePayoutScheduleRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ScheduleEnum {
        BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT("BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT"),
        DAILY("DAILY"),
        DAILY_AU("DAILY_AU"),
        DAILY_EU("DAILY_EU"),
        DAILY_SG("DAILY_SG"),
        DAILY_US("DAILY_US"),
        HOLD("HOLD"),
        MONTHLY("MONTHLY"),
        WEEKLY("WEEKLY"),
        WEEKLY_MON_TO_FRI_AU("WEEKLY_MON_TO_FRI_AU"),
        WEEKLY_MON_TO_FRI_EU("WEEKLY_MON_TO_FRI_EU"),
        WEEKLY_MON_TO_FRI_US("WEEKLY_MON_TO_FRI_US"),
        WEEKLY_ON_TUE_FRI_MIDNIGHT("WEEKLY_ON_TUE_FRI_MIDNIGHT"),
        WEEKLY_SUN_TO_THU_AU("WEEKLY_SUN_TO_THU_AU"),
        WEEKLY_SUN_TO_THU_US("WEEKLY_SUN_TO_THU_US");

        private String value;

        private ScheduleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScheduleEnum fromValue(String value) {
            for (ScheduleEnum b : ScheduleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ActionEnum {
        CLOSE("CLOSE"),
        NOTHING("NOTHING"),
        UPDATE("UPDATE");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

