/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.managementwebhooks;

import com.adyen.model.managementwebhooks.CapabilityProblem;
import com.adyen.model.managementwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"allowed", "allowedLevel", "capability", "problems", "requested", "requestedLevel", "verificationDeadline", "verificationStatus"})
public class AccountCapabilityData {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_ALLOWED_LEVEL = "allowedLevel";
    private String allowedLevel;
    public static final String JSON_PROPERTY_CAPABILITY = "capability";
    private String capability;
    public static final String JSON_PROPERTY_PROBLEMS = "problems";
    private List<CapabilityProblem> problems;
    public static final String JSON_PROPERTY_REQUESTED = "requested";
    private Boolean requested;
    public static final String JSON_PROPERTY_REQUESTED_LEVEL = "requestedLevel";
    private String requestedLevel;
    public static final String JSON_PROPERTY_VERIFICATION_DEADLINE = "verificationDeadline";
    private OffsetDateTime verificationDeadline;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private String verificationStatus;

    public AccountCapabilityData allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public AccountCapabilityData allowedLevel(String allowedLevel) {
        this.allowedLevel = allowedLevel;
        return this;
    }

    @JsonProperty(value="allowedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAllowedLevel() {
        return this.allowedLevel;
    }

    @JsonProperty(value="allowedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedLevel(String allowedLevel) {
        this.allowedLevel = allowedLevel;
    }

    public AccountCapabilityData capability(String capability) {
        this.capability = capability;
        return this;
    }

    @JsonProperty(value="capability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCapability() {
        return this.capability;
    }

    @JsonProperty(value="capability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapability(String capability) {
        this.capability = capability;
    }

    public AccountCapabilityData problems(List<CapabilityProblem> problems) {
        this.problems = problems;
        return this;
    }

    public AccountCapabilityData addProblemsItem(CapabilityProblem problemsItem) {
        if (this.problems == null) {
            this.problems = new ArrayList<CapabilityProblem>();
        }
        this.problems.add(problemsItem);
        return this;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilityProblem> getProblems() {
        return this.problems;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProblems(List<CapabilityProblem> problems) {
        this.problems = problems;
    }

    public AccountCapabilityData requested(Boolean requested) {
        this.requested = requested;
        return this;
    }

    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequested() {
        return this.requested;
    }

    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequested(Boolean requested) {
        this.requested = requested;
    }

    public AccountCapabilityData requestedLevel(String requestedLevel) {
        this.requestedLevel = requestedLevel;
        return this;
    }

    @JsonProperty(value="requestedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestedLevel() {
        return this.requestedLevel;
    }

    @JsonProperty(value="requestedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedLevel(String requestedLevel) {
        this.requestedLevel = requestedLevel;
    }

    public AccountCapabilityData verificationDeadline(OffsetDateTime verificationDeadline) {
        this.verificationDeadline = verificationDeadline;
        return this;
    }

    @JsonProperty(value="verificationDeadline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getVerificationDeadline() {
        return this.verificationDeadline;
    }

    @JsonProperty(value="verificationDeadline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationDeadline(OffsetDateTime verificationDeadline) {
        this.verificationDeadline = verificationDeadline;
    }

    public AccountCapabilityData verificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountCapabilityData accountCapabilityData = (AccountCapabilityData)o;
        return Objects.equals(this.allowed, accountCapabilityData.allowed) && Objects.equals(this.allowedLevel, accountCapabilityData.allowedLevel) && Objects.equals(this.capability, accountCapabilityData.capability) && Objects.equals(this.problems, accountCapabilityData.problems) && Objects.equals(this.requested, accountCapabilityData.requested) && Objects.equals(this.requestedLevel, accountCapabilityData.requestedLevel) && Objects.equals(this.verificationDeadline, accountCapabilityData.verificationDeadline) && Objects.equals(this.verificationStatus, accountCapabilityData.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.allowedLevel, this.capability, this.problems, this.requested, this.requestedLevel, this.verificationDeadline, this.verificationStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountCapabilityData {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    allowedLevel: ").append(this.toIndentedString(this.allowedLevel)).append("\n");
        sb.append("    capability: ").append(this.toIndentedString(this.capability)).append("\n");
        sb.append("    problems: ").append(this.toIndentedString(this.problems)).append("\n");
        sb.append("    requested: ").append(this.toIndentedString(this.requested)).append("\n");
        sb.append("    requestedLevel: ").append(this.toIndentedString(this.requestedLevel)).append("\n");
        sb.append("    verificationDeadline: ").append(this.toIndentedString(this.verificationDeadline)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString(this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountCapabilityData fromJson(String jsonString) throws JsonProcessingException {
        return (AccountCapabilityData)JSON.getMapper().readValue(jsonString, AccountCapabilityData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

