/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Amount;
import com.adyen.model.payout.JSON;
import com.adyen.model.payout.Name;
import com.adyen.model.payout.Recurring;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "amount", "dateOfBirth", "entityType", "fraudOffset", "merchantAccount", "nationality", "recurring", "reference", "selectedRecurringDetailReference", "shopperEmail", "shopperName", "shopperReference", "shopperStatement", "socialSecurityNumber"})
public class SubmitRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_NATIONALITY = "nationality";
    private String nationality;
    public static final String JSON_PROPERTY_RECURRING = "recurring";
    private Recurring recurring;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    private String selectedRecurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
    private String shopperStatement;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;

    public SubmitRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public SubmitRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public SubmitRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public SubmitRequest dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public SubmitRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public SubmitRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public SubmitRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public SubmitRequest nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public SubmitRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Recurring getRecurring() {
        return this.recurring;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public SubmitRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public SubmitRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return this;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public SubmitRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public SubmitRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public SubmitRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public SubmitRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public SubmitRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitRequest submitRequest = (SubmitRequest)o;
        return Objects.equals(this.additionalData, submitRequest.additionalData) && Objects.equals(this.amount, submitRequest.amount) && Objects.equals(this.dateOfBirth, submitRequest.dateOfBirth) && Objects.equals((Object)this.entityType, (Object)submitRequest.entityType) && Objects.equals(this.fraudOffset, submitRequest.fraudOffset) && Objects.equals(this.merchantAccount, submitRequest.merchantAccount) && Objects.equals(this.nationality, submitRequest.nationality) && Objects.equals(this.recurring, submitRequest.recurring) && Objects.equals(this.reference, submitRequest.reference) && Objects.equals(this.selectedRecurringDetailReference, submitRequest.selectedRecurringDetailReference) && Objects.equals(this.shopperEmail, submitRequest.shopperEmail) && Objects.equals(this.shopperName, submitRequest.shopperName) && Objects.equals(this.shopperReference, submitRequest.shopperReference) && Objects.equals(this.shopperStatement, submitRequest.shopperStatement) && Objects.equals(this.socialSecurityNumber, submitRequest.socialSecurityNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.amount, this.dateOfBirth, this.entityType, this.fraudOffset, this.merchantAccount, this.nationality, this.recurring, this.reference, this.selectedRecurringDetailReference, this.shopperEmail, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmitRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SubmitRequest fromJson(String jsonString) throws JsonProcessingException {
        return (SubmitRequest)JSON.getMapper().readValue(jsonString, SubmitRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EntityTypeEnum {
        NATURALPERSON(String.valueOf("NaturalPerson")),
        COMPANY(String.valueOf("Company"));

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

