/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.KYCCheckStatusData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "kycCheckStatusData", "legalArrangementCode", "legalArrangementEntityCode", "payoutMethodCode", "shareholderCode", "signatoryCode"})
public class AccountHolderVerificationNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_KYC_CHECK_STATUS_DATA = "kycCheckStatusData";
    private KYCCheckStatusData kycCheckStatusData;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
    private String legalArrangementCode;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE = "legalArrangementEntityCode";
    private String legalArrangementEntityCode;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;
    public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
    private String shareholderCode;
    public static final String JSON_PROPERTY_SIGNATORY_CODE = "signatoryCode";
    private String signatoryCode;

    public AccountHolderVerificationNotificationContent accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public AccountHolderVerificationNotificationContent kycCheckStatusData(KYCCheckStatusData kycCheckStatusData) {
        this.kycCheckStatusData = kycCheckStatusData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="kycCheckStatusData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KYCCheckStatusData getKycCheckStatusData() {
        return this.kycCheckStatusData;
    }

    @JsonProperty(value="kycCheckStatusData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKycCheckStatusData(KYCCheckStatusData kycCheckStatusData) {
        this.kycCheckStatusData = kycCheckStatusData;
    }

    public AccountHolderVerificationNotificationContent legalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the legal arrangement that has been verified.")
    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementCode() {
        return this.legalArrangementCode;
    }

    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
    }

    public AccountHolderVerificationNotificationContent legalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the legal arrangement entity that has been verified.")
    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementEntityCode() {
        return this.legalArrangementEntityCode;
    }

    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
    }

    public AccountHolderVerificationNotificationContent payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="The unique code of the payout method that has been verified.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public AccountHolderVerificationNotificationContent shareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the shareholder that has been verified.")
    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShareholderCode() {
        return this.shareholderCode;
    }

    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
    }

    public AccountHolderVerificationNotificationContent signatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
        return this;
    }

    @ApiModelProperty(value="The code of the signatory that has been verified.")
    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignatoryCode() {
        return this.signatoryCode;
    }

    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderVerificationNotificationContent accountHolderVerificationNotificationContent = (AccountHolderVerificationNotificationContent)o;
        return Objects.equals(this.accountHolderCode, accountHolderVerificationNotificationContent.accountHolderCode) && Objects.equals(this.kycCheckStatusData, accountHolderVerificationNotificationContent.kycCheckStatusData) && Objects.equals(this.legalArrangementCode, accountHolderVerificationNotificationContent.legalArrangementCode) && Objects.equals(this.legalArrangementEntityCode, accountHolderVerificationNotificationContent.legalArrangementEntityCode) && Objects.equals(this.payoutMethodCode, accountHolderVerificationNotificationContent.payoutMethodCode) && Objects.equals(this.shareholderCode, accountHolderVerificationNotificationContent.shareholderCode) && Objects.equals(this.signatoryCode, accountHolderVerificationNotificationContent.signatoryCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.kycCheckStatusData, this.legalArrangementCode, this.legalArrangementEntityCode, this.payoutMethodCode, this.shareholderCode, this.signatoryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderVerificationNotificationContent {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    kycCheckStatusData: ").append(this.toIndentedString(this.kycCheckStatusData)).append("\n");
        sb.append("    legalArrangementCode: ").append(this.toIndentedString(this.legalArrangementCode)).append("\n");
        sb.append("    legalArrangementEntityCode: ").append(this.toIndentedString(this.legalArrangementEntityCode)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("    shareholderCode: ").append(this.toIndentedString(this.shareholderCode)).append("\n");
        sb.append("    signatoryCode: ").append(this.toIndentedString(this.signatoryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderVerificationNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderVerificationNotificationContent)JSON.getMapper().readValue(jsonString, AccountHolderVerificationNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

