/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "requiredAddressFields", "type"})
public class AddressRequirement {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_REQUIRED_ADDRESS_FIELDS = "requiredAddressFields";
    private List<RequiredAddressFieldsEnum> requiredAddressFields;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.ADDRESSREQUIREMENT;

    public AddressRequirement description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AddressRequirement requiredAddressFields(List<RequiredAddressFieldsEnum> requiredAddressFields) {
        this.requiredAddressFields = requiredAddressFields;
        return this;
    }

    public AddressRequirement addRequiredAddressFieldsItem(RequiredAddressFieldsEnum requiredAddressFieldsItem) {
        if (this.requiredAddressFields == null) {
            this.requiredAddressFields = new ArrayList<RequiredAddressFieldsEnum>();
        }
        this.requiredAddressFields.add(requiredAddressFieldsItem);
        return this;
    }

    @JsonProperty(value="requiredAddressFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RequiredAddressFieldsEnum> getRequiredAddressFields() {
        return this.requiredAddressFields;
    }

    @JsonProperty(value="requiredAddressFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequiredAddressFields(List<RequiredAddressFieldsEnum> requiredAddressFields) {
        this.requiredAddressFields = requiredAddressFields;
    }

    public AddressRequirement type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressRequirement addressRequirement = (AddressRequirement)o;
        return Objects.equals(this.description, addressRequirement.description) && Objects.equals(this.requiredAddressFields, addressRequirement.requiredAddressFields) && Objects.equals((Object)this.type, (Object)addressRequirement.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.requiredAddressFields, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressRequirement {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    requiredAddressFields: ").append(this.toIndentedString(this.requiredAddressFields)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AddressRequirement fromJson(String jsonString) throws JsonProcessingException {
        return (AddressRequirement)JSON.getMapper().readValue(jsonString, AddressRequirement.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ADDRESSREQUIREMENT(String.valueOf("addressRequirement"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequiredAddressFieldsEnum {
        CITY(String.valueOf("city")),
        COUNTRY(String.valueOf("country")),
        LINE1(String.valueOf("line1")),
        POSTALCODE(String.valueOf("postalCode")),
        STATEORPROVINCE(String.valueOf("stateOrProvince"));

        private String value;

        private RequiredAddressFieldsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequiredAddressFieldsEnum fromValue(String value) {
            for (RequiredAddressFieldsEnum b : RequiredAddressFieldsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

