/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.TransferNotificationRequest;
import java.util.Optional;
import java.util.logging.Logger;

public class TransferWebhooksHandler {
    private static final Logger LOG = Logger.getLogger(TransferWebhooksHandler.class.getName());
    private final String payload;

    public TransferWebhooksHandler(String payload) {
        this.payload = payload;
    }

    public Optional<TransferNotificationRequest> getTransferNotificationRequest() {
        return this.getOptionalField(TransferNotificationRequest.class);
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

