/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "signatoryCodes"})
public class DeleteSignatoriesRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_SIGNATORY_CODES = "signatoryCodes";
    private List<String> signatoryCodes = new ArrayList<String>();

    public DeleteSignatoriesRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder from which to delete the signatories.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public DeleteSignatoriesRequest signatoryCodes(List<String> signatoryCodes) {
        this.signatoryCodes = signatoryCodes;
        return this;
    }

    public DeleteSignatoriesRequest addSignatoryCodesItem(String signatoryCodesItem) {
        this.signatoryCodes.add(signatoryCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of codes of the signatories to be deleted.")
    @JsonProperty(value="signatoryCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSignatoryCodes() {
        return this.signatoryCodes;
    }

    @JsonProperty(value="signatoryCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatoryCodes(List<String> signatoryCodes) {
        this.signatoryCodes = signatoryCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteSignatoriesRequest deleteSignatoriesRequest = (DeleteSignatoriesRequest)o;
        return Objects.equals(this.accountHolderCode, deleteSignatoriesRequest.accountHolderCode) && Objects.equals(this.signatoryCodes, deleteSignatoriesRequest.signatoryCodes);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.signatoryCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteSignatoriesRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    signatoryCodes: ").append(this.toIndentedString(this.signatoryCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DeleteSignatoriesRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DeleteSignatoriesRequest)JSON.getMapper().readValue(jsonString, DeleteSignatoriesRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

