/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AndroidAppError;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "errorCode", "errors", "id", "label", "packageName", "status", "versionCode", "versionName"})
public class AndroidApp {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    @Deprecated
    private String errorCode;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<AndroidAppError> errors = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_PACKAGE_NAME = "packageName";
    private String packageName;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_VERSION_CODE = "versionCode";
    private Integer versionCode;
    public static final String JSON_PROPERTY_VERSION_NAME = "versionName";
    private String versionName;

    public AndroidApp description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description that was provided when uploading the app. The description is not shown on the terminal.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public AndroidApp errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The error code of the Android app with the `status` of either **error** or **invalid**.")
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorCode() {
        return this.errorCode;
    }

    @Deprecated
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public AndroidApp errors(List<AndroidAppError> errors) {
        this.errors = errors;
        return this;
    }

    public AndroidApp addErrorsItem(AndroidAppError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<AndroidAppError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="The list of errors of the Android app.")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AndroidAppError> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(List<AndroidAppError> errors) {
        this.errors = errors;
    }

    public AndroidApp id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the app.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AndroidApp label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The app name that is shown on the terminal.")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public AndroidApp packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    @ApiModelProperty(value="The package name that uniquely identifies the Android app.")
    @JsonProperty(value="packageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPackageName() {
        return this.packageName;
    }

    @JsonProperty(value="packageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public AndroidApp status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the app. Possible values:  * `processing`: the app is being signed and converted to a format that the terminal can handle. * `error`: something went wrong. Check that the app matches the [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). * `invalid`: there is something wrong with the APK file of the app. * `ready`: the app has been signed and converted. * `archived`: the app is no longer available.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AndroidApp versionCode(Integer versionCode) {
        this.versionCode = versionCode;
        return this;
    }

    @ApiModelProperty(value="The version number of the app.")
    @JsonProperty(value="versionCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVersionCode() {
        return this.versionCode;
    }

    @JsonProperty(value="versionCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersionCode(Integer versionCode) {
        this.versionCode = versionCode;
    }

    public AndroidApp versionName(String versionName) {
        this.versionName = versionName;
        return this;
    }

    @ApiModelProperty(value="The app version number that is shown on the terminal.")
    @JsonProperty(value="versionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersionName() {
        return this.versionName;
    }

    @JsonProperty(value="versionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidApp androidApp = (AndroidApp)o;
        return Objects.equals(this.description, androidApp.description) && Objects.equals(this.errorCode, androidApp.errorCode) && Objects.equals(this.errors, androidApp.errors) && Objects.equals(this.id, androidApp.id) && Objects.equals(this.label, androidApp.label) && Objects.equals(this.packageName, androidApp.packageName) && Objects.equals((Object)this.status, (Object)androidApp.status) && Objects.equals(this.versionCode, androidApp.versionCode) && Objects.equals(this.versionName, androidApp.versionName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.errorCode, this.errors, this.id, this.label, this.packageName, this.status, this.versionCode, this.versionName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AndroidApp {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    packageName: ").append(this.toIndentedString(this.packageName)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    versionCode: ").append(this.toIndentedString(this.versionCode)).append("\n");
        sb.append("    versionName: ").append(this.toIndentedString(this.versionName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AndroidApp fromJson(String jsonString) throws JsonProcessingException {
        return (AndroidApp)JSON.getMapper().readValue(jsonString, AndroidApp.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ARCHIVED("archived"),
        ERROR("error"),
        INVALID("invalid"),
        PROCESSING("processing"),
        READY("ready");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

