/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"associatorId", "entityType", "jobTitle", "legalEntityId", "name", "nominee", "relationship", "settlorExemptionReason", "type"})
public class LegalEntityAssociation {
    public static final String JSON_PROPERTY_ASSOCIATOR_ID = "associatorId";
    private String associatorId;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private String entityType;
    public static final String JSON_PROPERTY_JOB_TITLE = "jobTitle";
    private String jobTitle;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NOMINEE = "nominee";
    private Boolean nominee;
    public static final String JSON_PROPERTY_RELATIONSHIP = "relationship";
    private String relationship;
    public static final String JSON_PROPERTY_SETTLOR_EXEMPTION_REASON = "settlorExemptionReason";
    private List<String> settlorExemptionReason = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public LegalEntityAssociation() {
    }

    @JsonCreator
    public LegalEntityAssociation(@JsonProperty(value="associatorId") String associatorId, @JsonProperty(value="entityType") String entityType, @JsonProperty(value="name") String name) {
        this();
        this.associatorId = associatorId;
        this.entityType = entityType;
        this.name = name;
    }

    @JsonProperty(value="associatorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssociatorId() {
        return this.associatorId;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEntityType() {
        return this.entityType;
    }

    public LegalEntityAssociation jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJobTitle() {
        return this.jobTitle;
    }

    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public LegalEntityAssociation legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public LegalEntityAssociation nominee(Boolean nominee) {
        this.nominee = nominee;
        return this;
    }

    @JsonProperty(value="nominee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNominee() {
        return this.nominee;
    }

    @JsonProperty(value="nominee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNominee(Boolean nominee) {
        this.nominee = nominee;
    }

    public LegalEntityAssociation relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    @JsonProperty(value="relationship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRelationship() {
        return this.relationship;
    }

    @JsonProperty(value="relationship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public LegalEntityAssociation settlorExemptionReason(List<String> settlorExemptionReason) {
        this.settlorExemptionReason = settlorExemptionReason;
        return this;
    }

    public LegalEntityAssociation addSettlorExemptionReasonItem(String settlorExemptionReasonItem) {
        if (this.settlorExemptionReason == null) {
            this.settlorExemptionReason = new ArrayList<String>();
        }
        this.settlorExemptionReason.add(settlorExemptionReasonItem);
        return this;
    }

    @JsonProperty(value="settlorExemptionReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSettlorExemptionReason() {
        return this.settlorExemptionReason;
    }

    @JsonProperty(value="settlorExemptionReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettlorExemptionReason(List<String> settlorExemptionReason) {
        this.settlorExemptionReason = settlorExemptionReason;
    }

    public LegalEntityAssociation type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityAssociation legalEntityAssociation = (LegalEntityAssociation)o;
        return Objects.equals(this.associatorId, legalEntityAssociation.associatorId) && Objects.equals(this.entityType, legalEntityAssociation.entityType) && Objects.equals(this.jobTitle, legalEntityAssociation.jobTitle) && Objects.equals(this.legalEntityId, legalEntityAssociation.legalEntityId) && Objects.equals(this.name, legalEntityAssociation.name) && Objects.equals(this.nominee, legalEntityAssociation.nominee) && Objects.equals(this.relationship, legalEntityAssociation.relationship) && Objects.equals(this.settlorExemptionReason, legalEntityAssociation.settlorExemptionReason) && Objects.equals((Object)this.type, (Object)legalEntityAssociation.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.associatorId, this.entityType, this.jobTitle, this.legalEntityId, this.name, this.nominee, this.relationship, this.settlorExemptionReason, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityAssociation {\n");
        sb.append("    associatorId: ").append(this.toIndentedString(this.associatorId)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nominee: ").append(this.toIndentedString(this.nominee)).append("\n");
        sb.append("    relationship: ").append(this.toIndentedString(this.relationship)).append("\n");
        sb.append("    settlorExemptionReason: ").append(this.toIndentedString(this.settlorExemptionReason)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalEntityAssociation fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntityAssociation)JSON.getMapper().readValue(jsonString, LegalEntityAssociation.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        DEFINEDBENEFICIARY(String.valueOf("definedBeneficiary")),
        DIRECTOR(String.valueOf("director")),
        IMMEDIATEPARENTCOMPANY(String.valueOf("immediateParentCompany")),
        LEGALREPRESENTATIVE(String.valueOf("legalRepresentative")),
        PCISIGNATORY(String.valueOf("pciSignatory")),
        PROTECTOR(String.valueOf("protector")),
        SECONDARYPARTNER(String.valueOf("secondaryPartner")),
        SECONDARYTRUSTEE(String.valueOf("secondaryTrustee")),
        SETTLOR(String.valueOf("settlor")),
        SIGNATORY(String.valueOf("signatory")),
        SOLEPROPRIETORSHIP(String.valueOf("soleProprietorship")),
        TRUST(String.valueOf("trust")),
        TRUSTOWNERSHIP(String.valueOf("trustOwnership")),
        UBOTHROUGHCONTROL(String.valueOf("uboThroughControl")),
        UBOTHROUGHOWNERSHIP(String.valueOf("uboThroughOwnership")),
        ULTIMATEPARENTCOMPANY(String.valueOf("ultimateParentCompany")),
        UNDEFINEDBENEFICIARY(String.valueOf("undefinedBeneficiary")),
        UNINCORPORATEDPARTNERSHIP(String.valueOf("unincorporatedPartnership"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

