/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "applicationInfo", "industryUsage", "lineItems", "merchantAccount", "reference", "splits"})
public class PaymentAmountUpdateRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_INDUSTRY_USAGE = "industryUsage";
    private IndustryUsageEnum industryUsage;
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits;

    public PaymentAmountUpdateRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentAmountUpdateRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentAmountUpdateRequest industryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
        return this;
    }

    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IndustryUsageEnum getIndustryUsage() {
        return this.industryUsage;
    }

    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
    }

    public PaymentAmountUpdateRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentAmountUpdateRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentAmountUpdateRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentAmountUpdateRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentAmountUpdateRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentAmountUpdateRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentAmountUpdateRequest paymentAmountUpdateRequest = (PaymentAmountUpdateRequest)o;
        return Objects.equals(this.amount, paymentAmountUpdateRequest.amount) && Objects.equals(this.applicationInfo, paymentAmountUpdateRequest.applicationInfo) && Objects.equals((Object)this.industryUsage, (Object)paymentAmountUpdateRequest.industryUsage) && Objects.equals(this.lineItems, paymentAmountUpdateRequest.lineItems) && Objects.equals(this.merchantAccount, paymentAmountUpdateRequest.merchantAccount) && Objects.equals(this.reference, paymentAmountUpdateRequest.reference) && Objects.equals(this.splits, paymentAmountUpdateRequest.splits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.applicationInfo, this.industryUsage, this.lineItems, this.merchantAccount, this.reference, this.splits});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentAmountUpdateRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    industryUsage: ").append(this.toIndentedString((Object)this.industryUsage)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentAmountUpdateRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentAmountUpdateRequest)JSON.getMapper().readValue(jsonString, PaymentAmountUpdateRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum IndustryUsageEnum {
        DELAYEDCHARGE(String.valueOf("delayedCharge")),
        INSTALLMENT(String.valueOf("installment")),
        NOSHOW(String.valueOf("noShow"));

        private String value;

        private IndustryUsageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IndustryUsageEnum fromValue(String value) {
            for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

