/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AccountHolder;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolders", "hasNext", "hasPrevious"})
public class PaginatedAccountHoldersResponse {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDERS = "accountHolders";
    private List<AccountHolder> accountHolders = new ArrayList<AccountHolder>();
    public static final String JSON_PROPERTY_HAS_NEXT = "hasNext";
    private Boolean hasNext;
    public static final String JSON_PROPERTY_HAS_PREVIOUS = "hasPrevious";
    private Boolean hasPrevious;

    public PaginatedAccountHoldersResponse accountHolders(List<AccountHolder> accountHolders) {
        this.accountHolders = accountHolders;
        return this;
    }

    public PaginatedAccountHoldersResponse addAccountHoldersItem(AccountHolder accountHoldersItem) {
        this.accountHolders.add(accountHoldersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of account holders.")
    @JsonProperty(value="accountHolders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountHolder> getAccountHolders() {
        return this.accountHolders;
    }

    @JsonProperty(value="accountHolders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolders(List<AccountHolder> accountHolders) {
        this.accountHolders = accountHolders;
    }

    public PaginatedAccountHoldersResponse hasNext(Boolean hasNext) {
        this.hasNext = hasNext;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the next page.")
    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasNext() {
        return this.hasNext;
    }

    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public PaginatedAccountHoldersResponse hasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the previous page.")
    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPrevious() {
        return this.hasPrevious;
    }

    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginatedAccountHoldersResponse paginatedAccountHoldersResponse = (PaginatedAccountHoldersResponse)o;
        return Objects.equals(this.accountHolders, paginatedAccountHoldersResponse.accountHolders) && Objects.equals(this.hasNext, paginatedAccountHoldersResponse.hasNext) && Objects.equals(this.hasPrevious, paginatedAccountHoldersResponse.hasPrevious);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolders, this.hasNext, this.hasPrevious);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginatedAccountHoldersResponse {\n");
        sb.append("    accountHolders: ").append(this.toIndentedString(this.accountHolders)).append("\n");
        sb.append("    hasNext: ").append(this.toIndentedString(this.hasNext)).append("\n");
        sb.append("    hasPrevious: ").append(this.toIndentedString(this.hasPrevious)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaginatedAccountHoldersResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaginatedAccountHoldersResponse)JSON.getMapper().readValue(jsonString, PaginatedAccountHoldersResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

