/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AllowedOrigin;
import com.adyen.model.management.ApiCredentialLinks;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"_links", "active", "allowedIpAddresses", "allowedOrigins", "clientKey", "companyName", "description", "id", "roles", "username"})
public class MeApiCredential {
    public static final String JSON_PROPERTY_LINKS = "_links";
    private ApiCredentialLinks links;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_ALLOWED_IP_ADDRESSES = "allowedIpAddresses";
    private List<String> allowedIpAddresses = new ArrayList<String>();
    public static final String JSON_PROPERTY_ALLOWED_ORIGINS = "allowedOrigins";
    private List<AllowedOrigin> allowedOrigins = null;
    public static final String JSON_PROPERTY_CLIENT_KEY = "clientKey";
    private String clientKey;
    public static final String JSON_PROPERTY_COMPANY_NAME = "companyName";
    private String companyName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public MeApiCredential links(ApiCredentialLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiCredentialLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ApiCredentialLinks links) {
        this.links = links;
    }

    public MeApiCredential active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the API credential is enabled. Must be set to **true** to use the credential in your integration.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public MeApiCredential allowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
        return this;
    }

    public MeApiCredential addAllowedIpAddressesItem(String allowedIpAddressesItem) {
        this.allowedIpAddresses.add(allowedIpAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of IP addresses from which your client can make requests.  If the list is empty, we allow requests from any IP. If the list is not empty and we get a request from an IP which is not on the list, you get a security error.")
    @JsonProperty(value="allowedIpAddresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAllowedIpAddresses() {
        return this.allowedIpAddresses;
    }

    @JsonProperty(value="allowedIpAddresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
    }

    public MeApiCredential allowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public MeApiCredential addAllowedOriginsItem(AllowedOrigin allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<AllowedOrigin>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="List containing the [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) linked to the API credential.")
    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AllowedOrigin> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public MeApiCredential clientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Public key used for [client-side authentication](https://docs.adyen.com/development-resources/client-side-authentication). The client key is required for Drop-in and Components integrations.")
    @JsonProperty(value="clientKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientKey() {
        return this.clientKey;
    }

    @JsonProperty(value="clientKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public MeApiCredential companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(value="Name of the company linked to the API credential.")
    @JsonProperty(value="companyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="companyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public MeApiCredential description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public MeApiCredential id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the API credential.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public MeApiCredential roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public MeApiCredential addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API credential.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public MeApiCredential username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials), for example **ws@Company.TestCompany**.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeApiCredential meApiCredential = (MeApiCredential)o;
        return Objects.equals(this.links, meApiCredential.links) && Objects.equals(this.active, meApiCredential.active) && Objects.equals(this.allowedIpAddresses, meApiCredential.allowedIpAddresses) && Objects.equals(this.allowedOrigins, meApiCredential.allowedOrigins) && Objects.equals(this.clientKey, meApiCredential.clientKey) && Objects.equals(this.companyName, meApiCredential.companyName) && Objects.equals(this.description, meApiCredential.description) && Objects.equals(this.id, meApiCredential.id) && Objects.equals(this.roles, meApiCredential.roles) && Objects.equals(this.username, meApiCredential.username);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.active, this.allowedIpAddresses, this.allowedOrigins, this.clientKey, this.companyName, this.description, this.id, this.roles, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeApiCredential {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    allowedIpAddresses: ").append(this.toIndentedString(this.allowedIpAddresses)).append("\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    clientKey: ").append(this.toIndentedString(this.clientKey)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MeApiCredential fromJson(String jsonString) throws JsonProcessingException {
        return (MeApiCredential)JSON.getMapper().readValue(jsonString, MeApiCredential.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

