/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantAccount", "payoutMethodCode", "payoutMethodReference", "recurringDetailReference", "shopperReference"})
public class PayoutMethod {
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_REFERENCE = "payoutMethodReference";
    private String payoutMethodReference;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;

    public PayoutMethod merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The [`merchantAccount`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_merchantAccount) you used in the `/payments` request when you [saved the account holder's card details](https://docs.adyen.com/marketplaces-and-platforms/classic/payouts/manual-payout/payout-to-cards#check-and-store).")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PayoutMethod payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="Adyen-generated unique alphanumeric identifier (UUID) for the payout method, returned in the response when you create a payout method. Required when updating an existing payout method in an `/updateAccountHolder` request.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public PayoutMethod payoutMethodReference(String payoutMethodReference) {
        this.payoutMethodReference = payoutMethodReference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payout method.")
    @JsonProperty(value="payoutMethodReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodReference() {
        return this.payoutMethodReference;
    }

    @JsonProperty(value="payoutMethodReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodReference(String payoutMethodReference) {
        this.payoutMethodReference = payoutMethodReference;
    }

    public PayoutMethod recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The [`recurringDetailReference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-recurring-recurringDetailReference)  returned in the `/payments` response when you [saved the account holder's card details](https://docs.adyen.com/marketplaces-and-platforms/classic/payouts/manual-payout/payout-to-cards#check-and-store).")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public PayoutMethod shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The [`shopperReference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_shopperReference) you sent in the `/payments` request when you [saved the account holder's card details](https://docs.adyen.com/marketplaces-and-platforms/classic/payouts/manual-payout/payout-to-cards#check-and-store).")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutMethod payoutMethod = (PayoutMethod)o;
        return Objects.equals(this.merchantAccount, payoutMethod.merchantAccount) && Objects.equals(this.payoutMethodCode, payoutMethod.payoutMethodCode) && Objects.equals(this.payoutMethodReference, payoutMethod.payoutMethodReference) && Objects.equals(this.recurringDetailReference, payoutMethod.recurringDetailReference) && Objects.equals(this.shopperReference, payoutMethod.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(this.merchantAccount, this.payoutMethodCode, this.payoutMethodReference, this.recurringDetailReference, this.shopperReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutMethod {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("    payoutMethodReference: ").append(this.toIndentedString(this.payoutMethodReference)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayoutMethod fromJson(String jsonString) throws JsonProcessingException {
        return (PayoutMethod)JSON.getMapper().readValue(jsonString, PayoutMethod.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

