/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"fixedAmount", "variablePercentage"})
public class Commission {
    public static final String JSON_PROPERTY_FIXED_AMOUNT = "fixedAmount";
    private Long fixedAmount;
    public static final String JSON_PROPERTY_VARIABLE_PERCENTAGE = "variablePercentage";
    private Long variablePercentage;

    public Commission fixedAmount(Long fixedAmount) {
        this.fixedAmount = fixedAmount;
        return this;
    }

    @ApiModelProperty(value="A fixed commission fee, in minor units.")
    @JsonProperty(value="fixedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFixedAmount() {
        return this.fixedAmount;
    }

    @JsonProperty(value="fixedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFixedAmount(Long fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public Commission variablePercentage(Long variablePercentage) {
        this.variablePercentage = variablePercentage;
        return this;
    }

    @ApiModelProperty(value="A variable commission fee, in basis points.")
    @JsonProperty(value="variablePercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVariablePercentage() {
        return this.variablePercentage;
    }

    @JsonProperty(value="variablePercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariablePercentage(Long variablePercentage) {
        this.variablePercentage = variablePercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commission commission = (Commission)o;
        return Objects.equals(this.fixedAmount, commission.fixedAmount) && Objects.equals(this.variablePercentage, commission.variablePercentage);
    }

    public int hashCode() {
        return Objects.hash(this.fixedAmount, this.variablePercentage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Commission {\n");
        sb.append("    fixedAmount: ").append(this.toIndentedString(this.fixedAmount)).append("\n");
        sb.append("    variablePercentage: ").append(this.toIndentedString(this.variablePercentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Commission fromJson(String jsonString) throws JsonProcessingException {
        return (Commission)JSON.getMapper().readValue(jsonString, Commission.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

