/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;

@JsonPropertyOrder(value={"authenticationResponse", "cavv", "cavvAlgorithm", "challengeCancel", "directoryResponse", "dsTransID", "eci", "riskScore", "threeDSVersion", "tokenAuthenticationVerificationValue", "transStatusReason", "xid"})
public class ThreeDSecureData {
    public static final String JSON_PROPERTY_AUTHENTICATION_RESPONSE = "authenticationResponse";
    private AuthenticationResponseEnum authenticationResponse;
    public static final String JSON_PROPERTY_CAVV = "cavv";
    private byte[] cavv;
    public static final String JSON_PROPERTY_CAVV_ALGORITHM = "cavvAlgorithm";
    private String cavvAlgorithm;
    public static final String JSON_PROPERTY_CHALLENGE_CANCEL = "challengeCancel";
    private ChallengeCancelEnum challengeCancel;
    public static final String JSON_PROPERTY_DIRECTORY_RESPONSE = "directoryResponse";
    private DirectoryResponseEnum directoryResponse;
    public static final String JSON_PROPERTY_DS_TRANS_I_D = "dsTransID";
    private String dsTransID;
    public static final String JSON_PROPERTY_ECI = "eci";
    private String eci;
    public static final String JSON_PROPERTY_RISK_SCORE = "riskScore";
    private String riskScore;
    public static final String JSON_PROPERTY_THREE_D_S_VERSION = "threeDSVersion";
    private String threeDSVersion;
    public static final String JSON_PROPERTY_TOKEN_AUTHENTICATION_VERIFICATION_VALUE = "tokenAuthenticationVerificationValue";
    private byte[] tokenAuthenticationVerificationValue;
    public static final String JSON_PROPERTY_TRANS_STATUS_REASON = "transStatusReason";
    private String transStatusReason;
    public static final String JSON_PROPERTY_XID = "xid";
    private byte[] xid;

    public ThreeDSecureData authenticationResponse(AuthenticationResponseEnum authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
        return this;
    }

    @ApiModelProperty(value="In 3D Secure 2, this is the `transStatus` from the challenge result. If the transaction was frictionless, omit this parameter.  ")
    @JsonProperty(value="authenticationResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthenticationResponseEnum getAuthenticationResponse() {
        return this.authenticationResponse;
    }

    @JsonProperty(value="authenticationResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationResponse(AuthenticationResponseEnum authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
    }

    public ThreeDSecureData cavv(byte[] cavv) {
        this.cavv = cavv;
        return this;
    }

    @ApiModelProperty(value="The cardholder authentication value (base64 encoded, 20 bytes in a decoded form).")
    @JsonProperty(value="cavv")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getCavv() {
        return this.cavv;
    }

    @JsonProperty(value="cavv")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCavv(byte[] cavv) {
        this.cavv = cavv;
    }

    public ThreeDSecureData cavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
        return this;
    }

    @ApiModelProperty(value="The CAVV algorithm used. Include this only for 3D Secure 1.")
    @JsonProperty(value="cavvAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCavvAlgorithm() {
        return this.cavvAlgorithm;
    }

    @JsonProperty(value="cavvAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
    }

    public ThreeDSecureData challengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
        return this;
    }

    @ApiModelProperty(value="Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).")
    @JsonProperty(value="challengeCancel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChallengeCancelEnum getChallengeCancel() {
        return this.challengeCancel;
    }

    @JsonProperty(value="challengeCancel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChallengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
    }

    public ThreeDSecureData directoryResponse(DirectoryResponseEnum directoryResponse) {
        this.directoryResponse = directoryResponse;
        return this;
    }

    @ApiModelProperty(value="In 3D Secure 2, this is the `transStatus` from the `ARes`.  ")
    @JsonProperty(value="directoryResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectoryResponseEnum getDirectoryResponse() {
        return this.directoryResponse;
    }

    @JsonProperty(value="directoryResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectoryResponse(DirectoryResponseEnum directoryResponse) {
        this.directoryResponse = directoryResponse;
    }

    public ThreeDSecureData dsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
        return this;
    }

    @ApiModelProperty(value="Supported for 3D Secure 2. The unique transaction identifier assigned by the Directory Server (DS) to identify a single transaction.")
    @JsonProperty(value="dsTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDsTransID() {
        return this.dsTransID;
    }

    @JsonProperty(value="dsTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
    }

    public ThreeDSecureData eci(String eci) {
        this.eci = eci;
        return this;
    }

    @ApiModelProperty(value="The electronic commerce indicator.")
    @JsonProperty(value="eci")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEci() {
        return this.eci;
    }

    @JsonProperty(value="eci")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEci(String eci) {
        this.eci = eci;
    }

    public ThreeDSecureData riskScore(String riskScore) {
        this.riskScore = riskScore;
        return this;
    }

    @ApiModelProperty(value="Risk score calculated by Directory Server (DS). Required for Cartes Bancaires integrations.")
    @JsonProperty(value="riskScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRiskScore() {
        return this.riskScore;
    }

    @JsonProperty(value="riskScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRiskScore(String riskScore) {
        this.riskScore = riskScore;
    }

    public ThreeDSecureData threeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @ApiModelProperty(value="The version of the 3D Secure protocol.")
    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSVersion() {
        return this.threeDSVersion;
    }

    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public ThreeDSecureData tokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
        this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
        return this;
    }

    @ApiModelProperty(value="Network token authentication verification value (TAVV). The network token cryptogram.")
    @JsonProperty(value="tokenAuthenticationVerificationValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getTokenAuthenticationVerificationValue() {
        return this.tokenAuthenticationVerificationValue;
    }

    @JsonProperty(value="tokenAuthenticationVerificationValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
        this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
    }

    public ThreeDSecureData transStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
        return this;
    }

    @ApiModelProperty(value="Provides information on why the `transStatus` field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).")
    @JsonProperty(value="transStatusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransStatusReason() {
        return this.transStatusReason;
    }

    @JsonProperty(value="transStatusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
    }

    public ThreeDSecureData xid(byte[] xid) {
        this.xid = xid;
        return this;
    }

    @ApiModelProperty(value="Supported for 3D Secure 1. The transaction identifier (Base64-encoded, 20 bytes in a decoded form).")
    @JsonProperty(value="xid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getXid() {
        return this.xid;
    }

    @JsonProperty(value="xid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXid(byte[] xid) {
        this.xid = xid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSecureData threeDSecureData = (ThreeDSecureData)o;
        return Objects.equals((Object)this.authenticationResponse, (Object)threeDSecureData.authenticationResponse) && Arrays.equals(this.cavv, threeDSecureData.cavv) && Objects.equals(this.cavvAlgorithm, threeDSecureData.cavvAlgorithm) && Objects.equals((Object)this.challengeCancel, (Object)threeDSecureData.challengeCancel) && Objects.equals((Object)this.directoryResponse, (Object)threeDSecureData.directoryResponse) && Objects.equals(this.dsTransID, threeDSecureData.dsTransID) && Objects.equals(this.eci, threeDSecureData.eci) && Objects.equals(this.riskScore, threeDSecureData.riskScore) && Objects.equals(this.threeDSVersion, threeDSecureData.threeDSVersion) && Arrays.equals(this.tokenAuthenticationVerificationValue, threeDSecureData.tokenAuthenticationVerificationValue) && Objects.equals(this.transStatusReason, threeDSecureData.transStatusReason) && Arrays.equals(this.xid, threeDSecureData.xid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationResponse, Arrays.hashCode(this.cavv), this.cavvAlgorithm, this.challengeCancel, this.directoryResponse, this.dsTransID, this.eci, this.riskScore, this.threeDSVersion, Arrays.hashCode(this.tokenAuthenticationVerificationValue), this.transStatusReason, Arrays.hashCode(this.xid)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSecureData {\n");
        sb.append("    authenticationResponse: ").append(this.toIndentedString((Object)this.authenticationResponse)).append("\n");
        sb.append("    cavv: ").append(this.toIndentedString(this.cavv)).append("\n");
        sb.append("    cavvAlgorithm: ").append(this.toIndentedString(this.cavvAlgorithm)).append("\n");
        sb.append("    challengeCancel: ").append(this.toIndentedString((Object)this.challengeCancel)).append("\n");
        sb.append("    directoryResponse: ").append(this.toIndentedString((Object)this.directoryResponse)).append("\n");
        sb.append("    dsTransID: ").append(this.toIndentedString(this.dsTransID)).append("\n");
        sb.append("    eci: ").append(this.toIndentedString(this.eci)).append("\n");
        sb.append("    riskScore: ").append(this.toIndentedString(this.riskScore)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString(this.threeDSVersion)).append("\n");
        sb.append("    tokenAuthenticationVerificationValue: ").append(this.toIndentedString(this.tokenAuthenticationVerificationValue)).append("\n");
        sb.append("    transStatusReason: ").append(this.toIndentedString(this.transStatusReason)).append("\n");
        sb.append("    xid: ").append(this.toIndentedString(this.xid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ThreeDSecureData fromJson(String jsonString) throws JsonProcessingException {
        return (ThreeDSecureData)JSON.getMapper().readValue(jsonString, ThreeDSecureData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum DirectoryResponseEnum {
        A("A"),
        C("C"),
        D("D"),
        I("I"),
        N("N"),
        R("R"),
        U("U"),
        Y("Y");

        private String value;

        private DirectoryResponseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectoryResponseEnum fromValue(String value) {
            for (DirectoryResponseEnum b : DirectoryResponseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChallengeCancelEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06"),
        _07("07");

        private String value;

        private ChallengeCancelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChallengeCancelEnum fromValue(String value) {
            for (ChallengeCancelEnum b : ChallengeCancelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AuthenticationResponseEnum {
        Y("Y"),
        N("N"),
        U("U"),
        A("A");

        private String value;

        private AuthenticationResponseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthenticationResponseEnum fromValue(String value) {
            for (AuthenticationResponseEnum b : AuthenticationResponseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

