/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.negativebalancewarningwebhooks;

import com.adyen.model.negativebalancewarningwebhooks.Amount;
import com.adyen.model.negativebalancewarningwebhooks.JSON;
import com.adyen.model.negativebalancewarningwebhooks.ResourceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolder", "amount", "balancePlatform", "creationDate", "id", "liableBalanceAccountId", "negativeBalanceSince", "scheduledCompensationAt"})
public class NegativeBalanceCompensationWarningNotificationData {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private ResourceReference accountHolder;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIABLE_BALANCE_ACCOUNT_ID = "liableBalanceAccountId";
    private String liableBalanceAccountId;
    public static final String JSON_PROPERTY_NEGATIVE_BALANCE_SINCE = "negativeBalanceSince";
    private OffsetDateTime negativeBalanceSince;
    public static final String JSON_PROPERTY_SCHEDULED_COMPENSATION_AT = "scheduledCompensationAt";
    private OffsetDateTime scheduledCompensationAt;

    public NegativeBalanceCompensationWarningNotificationData accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public NegativeBalanceCompensationWarningNotificationData amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public NegativeBalanceCompensationWarningNotificationData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public NegativeBalanceCompensationWarningNotificationData creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public NegativeBalanceCompensationWarningNotificationData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public NegativeBalanceCompensationWarningNotificationData liableBalanceAccountId(String liableBalanceAccountId) {
        this.liableBalanceAccountId = liableBalanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The balance account ID of the account that will be used to compensate the balance account whose balance is negative.")
    @JsonProperty(value="liableBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLiableBalanceAccountId() {
        return this.liableBalanceAccountId;
    }

    @JsonProperty(value="liableBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLiableBalanceAccountId(String liableBalanceAccountId) {
        this.liableBalanceAccountId = liableBalanceAccountId;
    }

    public NegativeBalanceCompensationWarningNotificationData negativeBalanceSince(OffsetDateTime negativeBalanceSince) {
        this.negativeBalanceSince = negativeBalanceSince;
        return this;
    }

    @ApiModelProperty(value="The date the balance for the account became negative.")
    @JsonProperty(value="negativeBalanceSince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getNegativeBalanceSince() {
        return this.negativeBalanceSince;
    }

    @JsonProperty(value="negativeBalanceSince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNegativeBalanceSince(OffsetDateTime negativeBalanceSince) {
        this.negativeBalanceSince = negativeBalanceSince;
    }

    public NegativeBalanceCompensationWarningNotificationData scheduledCompensationAt(OffsetDateTime scheduledCompensationAt) {
        this.scheduledCompensationAt = scheduledCompensationAt;
        return this;
    }

    @ApiModelProperty(value="The date when a compensation transfer to the account is scheduled to happen.")
    @JsonProperty(value="scheduledCompensationAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getScheduledCompensationAt() {
        return this.scheduledCompensationAt;
    }

    @JsonProperty(value="scheduledCompensationAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheduledCompensationAt(OffsetDateTime scheduledCompensationAt) {
        this.scheduledCompensationAt = scheduledCompensationAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NegativeBalanceCompensationWarningNotificationData negativeBalanceCompensationWarningNotificationData = (NegativeBalanceCompensationWarningNotificationData)o;
        return Objects.equals(this.accountHolder, negativeBalanceCompensationWarningNotificationData.accountHolder) && Objects.equals(this.amount, negativeBalanceCompensationWarningNotificationData.amount) && Objects.equals(this.balancePlatform, negativeBalanceCompensationWarningNotificationData.balancePlatform) && Objects.equals(this.creationDate, negativeBalanceCompensationWarningNotificationData.creationDate) && Objects.equals(this.id, negativeBalanceCompensationWarningNotificationData.id) && Objects.equals(this.liableBalanceAccountId, negativeBalanceCompensationWarningNotificationData.liableBalanceAccountId) && Objects.equals(this.negativeBalanceSince, negativeBalanceCompensationWarningNotificationData.negativeBalanceSince) && Objects.equals(this.scheduledCompensationAt, negativeBalanceCompensationWarningNotificationData.scheduledCompensationAt);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolder, this.amount, this.balancePlatform, this.creationDate, this.id, this.liableBalanceAccountId, this.negativeBalanceSince, this.scheduledCompensationAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NegativeBalanceCompensationWarningNotificationData {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liableBalanceAccountId: ").append(this.toIndentedString(this.liableBalanceAccountId)).append("\n");
        sb.append("    negativeBalanceSince: ").append(this.toIndentedString(this.negativeBalanceSince)).append("\n");
        sb.append("    scheduledCompensationAt: ").append(this.toIndentedString(this.scheduledCompensationAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NegativeBalanceCompensationWarningNotificationData fromJson(String jsonString) throws JsonProcessingException {
        return (NegativeBalanceCompensationWarningNotificationData)JSON.getMapper().readValue(jsonString, NegativeBalanceCompensationWarningNotificationData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

