/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "accountStateType", "tier"})
public class PerformVerificationRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_ACCOUNT_STATE_TYPE = "accountStateType";
    private AccountStateTypeEnum accountStateType;
    public static final String JSON_PROPERTY_TIER = "tier";
    private Integer tier;

    public PerformVerificationRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder to verify.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public PerformVerificationRequest accountStateType(AccountStateTypeEnum accountStateType) {
        this.accountStateType = accountStateType;
        return this;
    }

    @ApiModelProperty(required=true, value="The state required for the account holder. > Permitted values: `Processing`, `Payout`.")
    @JsonProperty(value="accountStateType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountStateTypeEnum getAccountStateType() {
        return this.accountStateType;
    }

    @JsonProperty(value="accountStateType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountStateType(AccountStateTypeEnum accountStateType) {
        this.accountStateType = accountStateType;
    }

    public PerformVerificationRequest tier(Integer tier) {
        this.tier = tier;
        return this;
    }

    @ApiModelProperty(required=true, value="The tier required for the account holder.")
    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTier() {
        return this.tier;
    }

    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTier(Integer tier) {
        this.tier = tier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformVerificationRequest performVerificationRequest = (PerformVerificationRequest)o;
        return Objects.equals(this.accountHolderCode, performVerificationRequest.accountHolderCode) && Objects.equals((Object)this.accountStateType, (Object)performVerificationRequest.accountStateType) && Objects.equals(this.tier, performVerificationRequest.tier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.accountStateType, this.tier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformVerificationRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    accountStateType: ").append(this.toIndentedString((Object)this.accountStateType)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString(this.tier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PerformVerificationRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PerformVerificationRequest)JSON.getMapper().readValue(jsonString, PerformVerificationRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum AccountStateTypeEnum {
        LIMITEDPAYOUT("LimitedPayout"),
        LIMITEDPROCESSING("LimitedProcessing"),
        LIMITLESSPAYOUT("LimitlessPayout"),
        LIMITLESSPROCESSING("LimitlessProcessing"),
        PAYOUT("Payout"),
        PROCESSING("Processing");

        private String value;

        private AccountStateTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountStateTypeEnum fromValue(String value) {
            for (AccountStateTypeEnum b : AccountStateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

