/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.terminal.security;

import com.adyen.model.nexo.MessageHeader;
import com.adyen.model.terminal.security.NexoDerivedKey;
import com.adyen.model.terminal.security.SaleToPOISecuredMessage;
import com.adyen.model.terminal.security.SecurityKey;
import com.adyen.model.terminal.security.SecurityTrailer;
import com.adyen.terminal.security.NexoDerivedKeyGenerator;
import com.adyen.terminal.security.exception.NexoCryptoException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class NexoCrypto {
    private final SecurityKey securityKey;
    private volatile NexoDerivedKey nexoDerivedKey;

    public NexoCrypto(SecurityKey securityKey) throws NexoCryptoException {
        this.validateSecurityKey(securityKey);
        this.securityKey = securityKey;
    }

    public SaleToPOISecuredMessage encrypt(String saleToPoiMessageJson, MessageHeader messageHeader) throws Exception {
        NexoDerivedKey derivedKey = this.getNexoDerivedKey();
        byte[] saleToPoiMessageByteArray = saleToPoiMessageJson.getBytes(StandardCharsets.UTF_8);
        byte[] ivNonce = this.generateRandomIvNonce();
        byte[] encryptedSaleToPoiMessage = this.crypt(saleToPoiMessageByteArray, derivedKey, ivNonce, 1);
        byte[] encryptedSaleToPoiMessageHmac = this.hmac(saleToPoiMessageByteArray, derivedKey);
        SecurityTrailer securityTrailer = new SecurityTrailer();
        securityTrailer.setKeyVersion(this.securityKey.getKeyVersion());
        securityTrailer.setKeyIdentifier(this.securityKey.getKeyIdentifier());
        securityTrailer.setHmac(encryptedSaleToPoiMessageHmac);
        securityTrailer.setNonce(ivNonce);
        securityTrailer.setAdyenCryptoVersion(this.securityKey.getAdyenCryptoVersion());
        SaleToPOISecuredMessage saleToPoiSecuredMessage = new SaleToPOISecuredMessage();
        saleToPoiSecuredMessage.setMessageHeader(messageHeader);
        saleToPoiSecuredMessage.setNexoBlob(new String(Base64.encodeBase64((byte[])encryptedSaleToPoiMessage)));
        saleToPoiSecuredMessage.setSecurityTrailer(securityTrailer);
        return saleToPoiSecuredMessage;
    }

    public String decrypt(SaleToPOISecuredMessage saleToPoiSecuredMessage) throws Exception {
        NexoDerivedKey derivedKey = this.getNexoDerivedKey();
        byte[] encryptedSaleToPoiMessageByteArray = Base64.decodeBase64((byte[])saleToPoiSecuredMessage.getNexoBlob().getBytes());
        byte[] ivNonce = saleToPoiSecuredMessage.getSecurityTrailer().getNonce();
        byte[] decryptedSaleToPoiMessageByteArray = this.crypt(encryptedSaleToPoiMessageByteArray, derivedKey, ivNonce, 2);
        byte[] receivedHmac = saleToPoiSecuredMessage.getSecurityTrailer().getHmac();
        this.validateHmac(receivedHmac, decryptedSaleToPoiMessageByteArray, derivedKey);
        return new String(decryptedSaleToPoiMessageByteArray, StandardCharsets.UTF_8);
    }

    private void validateSecurityKey(SecurityKey securityKey) throws NexoCryptoException {
        if (securityKey == null || securityKey.getPassphrase() == null || securityKey.getPassphrase().isEmpty() || securityKey.getKeyIdentifier() == null || securityKey.getKeyVersion() == null || securityKey.getAdyenCryptoVersion() == null) {
            throw new NexoCryptoException("Invalid Security Key");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NexoDerivedKey getNexoDerivedKey() throws GeneralSecurityException {
        if (this.nexoDerivedKey == null) {
            NexoCrypto nexoCrypto = this;
            synchronized (nexoCrypto) {
                if (this.nexoDerivedKey == null) {
                    this.nexoDerivedKey = NexoDerivedKeyGenerator.deriveKeyMaterial(this.securityKey.getPassphrase());
                }
            }
        }
        return this.nexoDerivedKey;
    }

    private byte[] crypt(byte[] bytes, NexoDerivedKey dk, byte[] ivNonce, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec secretKeySpec = new SecretKeySpec(dk.getCipherKey(), "AES");
        byte[] iv = dk.getIv();
        byte[] actualIV = new byte[16];
        for (int i = 0; i < 16; ++i) {
            actualIV[i] = (byte)(iv[i] ^ ivNonce[i]);
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(actualIV);
        cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
        return cipher.doFinal(bytes);
    }

    private byte[] hmac(byte[] bytes, NexoDerivedKey derivedKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec s = new SecretKeySpec(derivedKey.getHmacKey(), "HmacSHA256");
        mac.init(s);
        return mac.doFinal(bytes);
    }

    private void validateHmac(byte[] receivedHmac, byte[] decryptedMessage, NexoDerivedKey derivedKey) throws NexoCryptoException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] hmac = this.hmac(decryptedMessage, derivedKey);
        boolean valid = MessageDigest.isEqual(hmac, receivedHmac);
        if (!valid) {
            throw new NexoCryptoException("HMAC validation failed");
        }
    }

    private byte[] generateRandomIvNonce() {
        SecureRandom secureRandom;
        byte[] ivNonce = new byte[16];
        try {
            secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (Exception NoSuchAlgorithmException) {
            secureRandom = new SecureRandom();
        }
        secureRandom.nextBytes(ivNonce);
        return ivNonce;
    }
}

