/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.CustomerOrder;
import com.adyen.model.nexo.Instalment;
import com.adyen.model.nexo.PaymentInstrumentData;
import com.adyen.model.nexo.PaymentType;
import com.adyen.model.nexo.TransactionIdentification;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PaymentData", propOrder={"cardAcquisitionReference", "requestedValidityDate", "instalment", "customerOrder", "paymentInstrumentData"})
public class PaymentData {
    @XmlElement(name="CardAcquisitionReference")
    @Schema(description="Reference to the last CardAcquisition, to use the same card. --Rule: if the card data comes from a previous CardAcquisition")
    protected TransactionIdentification cardAcquisitionReference;
    @XmlElement(name="RequestedValidityDate")
    @Schema(description="Requested validity date for the reservation. --Rule: If time period of the OneTimeReservation, FirstReservation or UpdateReservation is requested")
    protected String requestedValidityDate;
    @XmlElement(name="Instalment")
    @Schema(description="Information related an instalment transaction. --Rule: If PaymentType is \"Instalment\" or \"IssuerInstalment\"")
    protected Instalment instalment;
    @XmlElement(name="CustomerOrder")
    @Schema(description="Customer order attached to a card, recorded in the POI system. --Rule: If a customer orders has to be created.")
    protected CustomerOrder customerOrder;
    @XmlElement(name="PaymentInstrumentData")
    @Schema(description="Data related to the instrument of payment for the transaction. --Rule: If payment instrument data are read by the Sale System")
    protected PaymentInstrumentData paymentInstrumentData;
    @XmlElement(name="PaymentType")
    @Schema(description="Type of payment transaction.")
    protected PaymentType paymentType;
    @XmlElement(name="SplitPaymentFlag")
    @Schema(description="Indicates if the payment of the Sale transaction is split.")
    protected Boolean splitPaymentFlag;

    public TransactionIdentification getCardAcquisitionReference() {
        return this.cardAcquisitionReference;
    }

    public void setCardAcquisitionReference(TransactionIdentification value) {
        this.cardAcquisitionReference = value;
    }

    public String getRequestedValidityDate() {
        return this.requestedValidityDate;
    }

    public void setRequestedValidityDate(String value) {
        this.requestedValidityDate = value;
    }

    public Instalment getInstalment() {
        return this.instalment;
    }

    public void setInstalment(Instalment value) {
        this.instalment = value;
    }

    public CustomerOrder getCustomerOrder() {
        return this.customerOrder;
    }

    public void setCustomerOrder(CustomerOrder value) {
        this.customerOrder = value;
    }

    public PaymentInstrumentData getPaymentInstrumentData() {
        return this.paymentInstrumentData;
    }

    public void setPaymentInstrumentData(PaymentInstrumentData value) {
        this.paymentInstrumentData = value;
    }

    public PaymentType getPaymentType() {
        if (this.paymentType == null) {
            return PaymentType.NORMAL;
        }
        return this.paymentType;
    }

    public void setPaymentType(PaymentType value) {
        this.paymentType = value;
    }

    public boolean isSplitPaymentFlag() {
        if (this.splitPaymentFlag == null) {
            return false;
        }
        return this.splitPaymentFlag;
    }

    public void setSplitPaymentFlag(Boolean value) {
        this.splitPaymentFlag = value;
    }
}

