/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"language", "secondaryLanguage", "timezone"})
public class Localization {
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_SECONDARY_LANGUAGE = "secondaryLanguage";
    private String secondaryLanguage;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public Localization language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="Language of the terminal.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public Localization secondaryLanguage(String secondaryLanguage) {
        this.secondaryLanguage = secondaryLanguage;
        return this;
    }

    @ApiModelProperty(value="Secondary language of the terminal.")
    @JsonProperty(value="secondaryLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecondaryLanguage() {
        return this.secondaryLanguage;
    }

    @JsonProperty(value="secondaryLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecondaryLanguage(String secondaryLanguage) {
        this.secondaryLanguage = secondaryLanguage;
    }

    public Localization timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the terminal.")
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Localization localization = (Localization)o;
        return Objects.equals(this.language, localization.language) && Objects.equals(this.secondaryLanguage, localization.secondaryLanguage) && Objects.equals(this.timezone, localization.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.language, this.secondaryLanguage, this.timezone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Localization {\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    secondaryLanguage: ").append(this.toIndentedString(this.secondaryLanguage)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Localization fromJson(String jsonString) throws JsonProcessingException {
        return (Localization)JSON.getMapper().readValue(jsonString, Localization.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

