/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"bankAccountNumber", "bankLocationId", "brand", "expiryMonth", "expiryYear", "holderName", "iban", "id", "label", "lastFour", "name", "networkTxReference", "ownerName", "shopperEmail", "supportedRecurringProcessingModels", "supportedShopperInteractions", "type"})
public class StoredPaymentMethod {
    public static final String JSON_PROPERTY_BANK_ACCOUNT_NUMBER = "bankAccountNumber";
    private String bankAccountNumber;
    public static final String JSON_PROPERTY_BANK_LOCATION_ID = "bankLocationId";
    private String bankLocationId;
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_EXPIRY_MONTH = "expiryMonth";
    private String expiryMonth;
    public static final String JSON_PROPERTY_EXPIRY_YEAR = "expiryYear";
    private String expiryYear;
    public static final String JSON_PROPERTY_HOLDER_NAME = "holderName";
    private String holderName;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LAST_FOUR = "lastFour";
    private String lastFour;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NETWORK_TX_REFERENCE = "networkTxReference";
    private String networkTxReference;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SUPPORTED_RECURRING_PROCESSING_MODELS = "supportedRecurringProcessingModels";
    private List<String> supportedRecurringProcessingModels = null;
    public static final String JSON_PROPERTY_SUPPORTED_SHOPPER_INTERACTIONS = "supportedShopperInteractions";
    private List<String> supportedShopperInteractions = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public StoredPaymentMethod bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="The bank account number (without separators).")
    @JsonProperty(value="bankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    @JsonProperty(value="bankAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public StoredPaymentMethod bankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
        return this;
    }

    @ApiModelProperty(value="The location id of the bank. The field value is `nil` in most cases.")
    @JsonProperty(value="bankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankLocationId() {
        return this.bankLocationId;
    }

    @JsonProperty(value="bankLocationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
    }

    public StoredPaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="The brand of the card.")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public StoredPaymentMethod expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @ApiModelProperty(value="The month the card expires.")
    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public StoredPaymentMethod expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @ApiModelProperty(value="The last two digits of the year the card expires. For example, **22** for the year 2022.")
    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryYear() {
        return this.expiryYear;
    }

    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public StoredPaymentMethod holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @ApiModelProperty(value="The unique payment method code.")
    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHolderName() {
        return this.holderName;
    }

    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public StoredPaymentMethod iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="The IBAN of the bank account.")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIban(String iban) {
        this.iban = iban;
    }

    public StoredPaymentMethod id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique identifier of this stored payment method.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public StoredPaymentMethod label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The shopper\u2019s issuer account label")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public StoredPaymentMethod lastFour(String lastFour) {
        this.lastFour = lastFour;
        return this;
    }

    @ApiModelProperty(value="The last four digits of the PAN.")
    @JsonProperty(value="lastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastFour() {
        return this.lastFour;
    }

    @JsonProperty(value="lastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastFour(String lastFour) {
        this.lastFour = lastFour;
    }

    public StoredPaymentMethod name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The display name of the stored payment method.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public StoredPaymentMethod networkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
        return this;
    }

    @ApiModelProperty(value="Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.")
    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkTxReference() {
        return this.networkTxReference;
    }

    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
    }

    public StoredPaymentMethod ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank account holder.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public StoredPaymentMethod shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper\u2019s email address.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public StoredPaymentMethod supportedRecurringProcessingModels(List<String> supportedRecurringProcessingModels) {
        this.supportedRecurringProcessingModels = supportedRecurringProcessingModels;
        return this;
    }

    public StoredPaymentMethod addSupportedRecurringProcessingModelsItem(String supportedRecurringProcessingModelsItem) {
        if (this.supportedRecurringProcessingModels == null) {
            this.supportedRecurringProcessingModels = new ArrayList<String>();
        }
        this.supportedRecurringProcessingModels.add(supportedRecurringProcessingModelsItem);
        return this;
    }

    @ApiModelProperty(value="The supported recurring processing models for this stored payment method.")
    @JsonProperty(value="supportedRecurringProcessingModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedRecurringProcessingModels() {
        return this.supportedRecurringProcessingModels;
    }

    @JsonProperty(value="supportedRecurringProcessingModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedRecurringProcessingModels(List<String> supportedRecurringProcessingModels) {
        this.supportedRecurringProcessingModels = supportedRecurringProcessingModels;
    }

    public StoredPaymentMethod supportedShopperInteractions(List<String> supportedShopperInteractions) {
        this.supportedShopperInteractions = supportedShopperInteractions;
        return this;
    }

    public StoredPaymentMethod addSupportedShopperInteractionsItem(String supportedShopperInteractionsItem) {
        if (this.supportedShopperInteractions == null) {
            this.supportedShopperInteractions = new ArrayList<String>();
        }
        this.supportedShopperInteractions.add(supportedShopperInteractionsItem);
        return this;
    }

    @ApiModelProperty(value="The supported shopper interactions for this stored payment method.")
    @JsonProperty(value="supportedShopperInteractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedShopperInteractions() {
        return this.supportedShopperInteractions;
    }

    @JsonProperty(value="supportedShopperInteractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedShopperInteractions(List<String> supportedShopperInteractions) {
        this.supportedShopperInteractions = supportedShopperInteractions;
    }

    public StoredPaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of payment method.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredPaymentMethod storedPaymentMethod = (StoredPaymentMethod)o;
        return Objects.equals(this.bankAccountNumber, storedPaymentMethod.bankAccountNumber) && Objects.equals(this.bankLocationId, storedPaymentMethod.bankLocationId) && Objects.equals(this.brand, storedPaymentMethod.brand) && Objects.equals(this.expiryMonth, storedPaymentMethod.expiryMonth) && Objects.equals(this.expiryYear, storedPaymentMethod.expiryYear) && Objects.equals(this.holderName, storedPaymentMethod.holderName) && Objects.equals(this.iban, storedPaymentMethod.iban) && Objects.equals(this.id, storedPaymentMethod.id) && Objects.equals(this.label, storedPaymentMethod.label) && Objects.equals(this.lastFour, storedPaymentMethod.lastFour) && Objects.equals(this.name, storedPaymentMethod.name) && Objects.equals(this.networkTxReference, storedPaymentMethod.networkTxReference) && Objects.equals(this.ownerName, storedPaymentMethod.ownerName) && Objects.equals(this.shopperEmail, storedPaymentMethod.shopperEmail) && Objects.equals(this.supportedRecurringProcessingModels, storedPaymentMethod.supportedRecurringProcessingModels) && Objects.equals(this.supportedShopperInteractions, storedPaymentMethod.supportedShopperInteractions) && Objects.equals(this.type, storedPaymentMethod.type);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccountNumber, this.bankLocationId, this.brand, this.expiryMonth, this.expiryYear, this.holderName, this.iban, this.id, this.label, this.lastFour, this.name, this.networkTxReference, this.ownerName, this.shopperEmail, this.supportedRecurringProcessingModels, this.supportedShopperInteractions, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredPaymentMethod {\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    bankLocationId: ").append(this.toIndentedString(this.bankLocationId)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    lastFour: ").append(this.toIndentedString(this.lastFour)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    networkTxReference: ").append(this.toIndentedString(this.networkTxReference)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    supportedRecurringProcessingModels: ").append(this.toIndentedString(this.supportedRecurringProcessingModels)).append("\n");
        sb.append("    supportedShopperInteractions: ").append(this.toIndentedString(this.supportedShopperInteractions)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredPaymentMethod fromJson(String jsonString) throws JsonProcessingException {
        return (StoredPaymentMethod)JSON.getMapper().readValue(jsonString, StoredPaymentMethod.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

