/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.KYCCheckResult;
import com.adyen.model.marketpayaccount.KYCLegalArrangementCheckResult;
import com.adyen.model.marketpayaccount.KYCLegalArrangementEntityCheckResult;
import com.adyen.model.marketpayaccount.KYCPayoutMethodCheckResult;
import com.adyen.model.marketpayaccount.KYCShareholderCheckResult;
import com.adyen.model.marketpayaccount.KYCSignatoryCheckResult;
import com.adyen.model.marketpayaccount.KYCUltimateParentCompanyCheckResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolder", "legalArrangements", "legalArrangementsEntities", "payoutMethods", "shareholders", "signatories", "ultimateParentCompany"})
public class KYCVerificationResult {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private KYCCheckResult accountHolder;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENTS = "legalArrangements";
    private List<KYCLegalArrangementCheckResult> legalArrangements = null;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENTS_ENTITIES = "legalArrangementsEntities";
    private List<KYCLegalArrangementEntityCheckResult> legalArrangementsEntities = null;
    public static final String JSON_PROPERTY_PAYOUT_METHODS = "payoutMethods";
    private List<KYCPayoutMethodCheckResult> payoutMethods = null;
    public static final String JSON_PROPERTY_SHAREHOLDERS = "shareholders";
    private List<KYCShareholderCheckResult> shareholders = null;
    public static final String JSON_PROPERTY_SIGNATORIES = "signatories";
    private List<KYCSignatoryCheckResult> signatories = null;
    public static final String JSON_PROPERTY_ULTIMATE_PARENT_COMPANY = "ultimateParentCompany";
    private List<KYCUltimateParentCompanyCheckResult> ultimateParentCompany = null;

    public KYCVerificationResult accountHolder(KYCCheckResult accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KYCCheckResult getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(KYCCheckResult accountHolder) {
        this.accountHolder = accountHolder;
    }

    public KYCVerificationResult legalArrangements(List<KYCLegalArrangementCheckResult> legalArrangements) {
        this.legalArrangements = legalArrangements;
        return this;
    }

    public KYCVerificationResult addLegalArrangementsItem(KYCLegalArrangementCheckResult legalArrangementsItem) {
        if (this.legalArrangements == null) {
            this.legalArrangements = new ArrayList<KYCLegalArrangementCheckResult>();
        }
        this.legalArrangements.add(legalArrangementsItem);
        return this;
    }

    @ApiModelProperty(value="The results of the checks on the legal arrangements.")
    @JsonProperty(value="legalArrangements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCLegalArrangementCheckResult> getLegalArrangements() {
        return this.legalArrangements;
    }

    @JsonProperty(value="legalArrangements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangements(List<KYCLegalArrangementCheckResult> legalArrangements) {
        this.legalArrangements = legalArrangements;
    }

    public KYCVerificationResult legalArrangementsEntities(List<KYCLegalArrangementEntityCheckResult> legalArrangementsEntities) {
        this.legalArrangementsEntities = legalArrangementsEntities;
        return this;
    }

    public KYCVerificationResult addLegalArrangementsEntitiesItem(KYCLegalArrangementEntityCheckResult legalArrangementsEntitiesItem) {
        if (this.legalArrangementsEntities == null) {
            this.legalArrangementsEntities = new ArrayList<KYCLegalArrangementEntityCheckResult>();
        }
        this.legalArrangementsEntities.add(legalArrangementsEntitiesItem);
        return this;
    }

    @ApiModelProperty(value="The results of the checks on the legal arrangement entities.")
    @JsonProperty(value="legalArrangementsEntities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCLegalArrangementEntityCheckResult> getLegalArrangementsEntities() {
        return this.legalArrangementsEntities;
    }

    @JsonProperty(value="legalArrangementsEntities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementsEntities(List<KYCLegalArrangementEntityCheckResult> legalArrangementsEntities) {
        this.legalArrangementsEntities = legalArrangementsEntities;
    }

    public KYCVerificationResult payoutMethods(List<KYCPayoutMethodCheckResult> payoutMethods) {
        this.payoutMethods = payoutMethods;
        return this;
    }

    public KYCVerificationResult addPayoutMethodsItem(KYCPayoutMethodCheckResult payoutMethodsItem) {
        if (this.payoutMethods == null) {
            this.payoutMethods = new ArrayList<KYCPayoutMethodCheckResult>();
        }
        this.payoutMethods.add(payoutMethodsItem);
        return this;
    }

    @ApiModelProperty(value="The results of the checks on the payout methods.")
    @JsonProperty(value="payoutMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCPayoutMethodCheckResult> getPayoutMethods() {
        return this.payoutMethods;
    }

    @JsonProperty(value="payoutMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethods(List<KYCPayoutMethodCheckResult> payoutMethods) {
        this.payoutMethods = payoutMethods;
    }

    public KYCVerificationResult shareholders(List<KYCShareholderCheckResult> shareholders) {
        this.shareholders = shareholders;
        return this;
    }

    public KYCVerificationResult addShareholdersItem(KYCShareholderCheckResult shareholdersItem) {
        if (this.shareholders == null) {
            this.shareholders = new ArrayList<KYCShareholderCheckResult>();
        }
        this.shareholders.add(shareholdersItem);
        return this;
    }

    @ApiModelProperty(value="The results of the checks on the shareholders.")
    @JsonProperty(value="shareholders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCShareholderCheckResult> getShareholders() {
        return this.shareholders;
    }

    @JsonProperty(value="shareholders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholders(List<KYCShareholderCheckResult> shareholders) {
        this.shareholders = shareholders;
    }

    public KYCVerificationResult signatories(List<KYCSignatoryCheckResult> signatories) {
        this.signatories = signatories;
        return this;
    }

    public KYCVerificationResult addSignatoriesItem(KYCSignatoryCheckResult signatoriesItem) {
        if (this.signatories == null) {
            this.signatories = new ArrayList<KYCSignatoryCheckResult>();
        }
        this.signatories.add(signatoriesItem);
        return this;
    }

    @ApiModelProperty(value="The results of the checks on the signatories.")
    @JsonProperty(value="signatories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCSignatoryCheckResult> getSignatories() {
        return this.signatories;
    }

    @JsonProperty(value="signatories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatories(List<KYCSignatoryCheckResult> signatories) {
        this.signatories = signatories;
    }

    public KYCVerificationResult ultimateParentCompany(List<KYCUltimateParentCompanyCheckResult> ultimateParentCompany) {
        this.ultimateParentCompany = ultimateParentCompany;
        return this;
    }

    public KYCVerificationResult addUltimateParentCompanyItem(KYCUltimateParentCompanyCheckResult ultimateParentCompanyItem) {
        if (this.ultimateParentCompany == null) {
            this.ultimateParentCompany = new ArrayList<KYCUltimateParentCompanyCheckResult>();
        }
        this.ultimateParentCompany.add(ultimateParentCompanyItem);
        return this;
    }

    @ApiModelProperty(value="The result of the check on the Ultimate Parent Company.")
    @JsonProperty(value="ultimateParentCompany")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCUltimateParentCompanyCheckResult> getUltimateParentCompany() {
        return this.ultimateParentCompany;
    }

    @JsonProperty(value="ultimateParentCompany")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUltimateParentCompany(List<KYCUltimateParentCompanyCheckResult> ultimateParentCompany) {
        this.ultimateParentCompany = ultimateParentCompany;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KYCVerificationResult kyCVerificationResult = (KYCVerificationResult)o;
        return Objects.equals(this.accountHolder, kyCVerificationResult.accountHolder) && Objects.equals(this.legalArrangements, kyCVerificationResult.legalArrangements) && Objects.equals(this.legalArrangementsEntities, kyCVerificationResult.legalArrangementsEntities) && Objects.equals(this.payoutMethods, kyCVerificationResult.payoutMethods) && Objects.equals(this.shareholders, kyCVerificationResult.shareholders) && Objects.equals(this.signatories, kyCVerificationResult.signatories) && Objects.equals(this.ultimateParentCompany, kyCVerificationResult.ultimateParentCompany);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolder, this.legalArrangements, this.legalArrangementsEntities, this.payoutMethods, this.shareholders, this.signatories, this.ultimateParentCompany);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KYCVerificationResult {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    legalArrangements: ").append(this.toIndentedString(this.legalArrangements)).append("\n");
        sb.append("    legalArrangementsEntities: ").append(this.toIndentedString(this.legalArrangementsEntities)).append("\n");
        sb.append("    payoutMethods: ").append(this.toIndentedString(this.payoutMethods)).append("\n");
        sb.append("    shareholders: ").append(this.toIndentedString(this.shareholders)).append("\n");
        sb.append("    signatories: ").append(this.toIndentedString(this.signatories)).append("\n");
        sb.append("    ultimateParentCompany: ").append(this.toIndentedString(this.ultimateParentCompany)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static KYCVerificationResult fromJson(String jsonString) throws JsonProcessingException {
        return (KYCVerificationResult)JSON.getMapper().readValue(jsonString, KYCVerificationResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

