/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"midNumber", "reuseMidNumber", "serviceLevel"})
public class AmexInfo {
    public static final String JSON_PROPERTY_MID_NUMBER = "midNumber";
    private String midNumber;
    public static final String JSON_PROPERTY_REUSE_MID_NUMBER = "reuseMidNumber";
    private Boolean reuseMidNumber;
    public static final String JSON_PROPERTY_SERVICE_LEVEL = "serviceLevel";
    private ServiceLevelEnum serviceLevel;

    public AmexInfo midNumber(String midNumber) {
        this.midNumber = midNumber;
        return this;
    }

    @ApiModelProperty(value="Merchant ID (MID) number. Format: 10 numeric characters.  You must provide this field when you request `gatewayContract` or `paymentDesignatorContract` service levels.")
    @JsonProperty(value="midNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMidNumber() {
        return this.midNumber;
    }

    @JsonProperty(value="midNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMidNumber(String midNumber) {
        this.midNumber = midNumber;
    }

    public AmexInfo reuseMidNumber(Boolean reuseMidNumber) {
        this.reuseMidNumber = reuseMidNumber;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the Amex Merchant ID is reused from a previously setup Amex payment method.  This is only applicable for `gatewayContract` and `paymentDesignatorContract` service levels.  The default value is **false**.")
    @JsonProperty(value="reuseMidNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReuseMidNumber() {
        return this.reuseMidNumber;
    }

    @JsonProperty(value="reuseMidNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReuseMidNumber(Boolean reuseMidNumber) {
        this.reuseMidNumber = reuseMidNumber;
    }

    public AmexInfo serviceLevel(ServiceLevelEnum serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the service level (settlement type) of this payment method. Possible values: * **noContract**: Adyen holds the contract with American Express. * **gatewayContract**: American Express receives the settlement and handles disputes, then pays out to you or your sub-merchant directly. * **paymentDesignatorContract**: Adyen receives the settlement, and handles disputes and payouts.")
    @JsonProperty(value="serviceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceLevelEnum getServiceLevel() {
        return this.serviceLevel;
    }

    @JsonProperty(value="serviceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceLevel(ServiceLevelEnum serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmexInfo amexInfo = (AmexInfo)o;
        return Objects.equals(this.midNumber, amexInfo.midNumber) && Objects.equals(this.reuseMidNumber, amexInfo.reuseMidNumber) && Objects.equals((Object)this.serviceLevel, (Object)amexInfo.serviceLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.midNumber, this.reuseMidNumber, this.serviceLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmexInfo {\n");
        sb.append("    midNumber: ").append(this.toIndentedString(this.midNumber)).append("\n");
        sb.append("    reuseMidNumber: ").append(this.toIndentedString(this.reuseMidNumber)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString((Object)this.serviceLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AmexInfo fromJson(String jsonString) throws JsonProcessingException {
        return (AmexInfo)JSON.getMapper().readValue(jsonString, AmexInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ServiceLevelEnum {
        NOCONTRACT("noContract"),
        GATEWAYCONTRACT("gatewayContract"),
        PAYMENTDESIGNATORCONTRACT("paymentDesignatorContract");

        private String value;

        private ServiceLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceLevelEnum fromValue(String value) {
            for (ServiceLevelEnum b : ServiceLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

