/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.disputes;

import com.adyen.model.disputes.DefenseDocumentType;
import com.adyen.model.disputes.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"defenseDocumentTypes", "defenseReasonCode", "satisfied"})
public class DefenseReason {
    public static final String JSON_PROPERTY_DEFENSE_DOCUMENT_TYPES = "defenseDocumentTypes";
    private List<DefenseDocumentType> defenseDocumentTypes = null;
    public static final String JSON_PROPERTY_DEFENSE_REASON_CODE = "defenseReasonCode";
    private String defenseReasonCode;
    public static final String JSON_PROPERTY_SATISFIED = "satisfied";
    private Boolean satisfied;

    public DefenseReason defenseDocumentTypes(List<DefenseDocumentType> defenseDocumentTypes) {
        this.defenseDocumentTypes = defenseDocumentTypes;
        return this;
    }

    public DefenseReason addDefenseDocumentTypesItem(DefenseDocumentType defenseDocumentTypesItem) {
        if (this.defenseDocumentTypes == null) {
            this.defenseDocumentTypes = new ArrayList<DefenseDocumentType>();
        }
        this.defenseDocumentTypes.add(defenseDocumentTypesItem);
        return this;
    }

    @ApiModelProperty(value="Array of defense document types for a specific defense reason. Indicates the document types that you can submit to the schemes to defend this dispute, and whether they are required.")
    @JsonProperty(value="defenseDocumentTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DefenseDocumentType> getDefenseDocumentTypes() {
        return this.defenseDocumentTypes;
    }

    @JsonProperty(value="defenseDocumentTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefenseDocumentTypes(List<DefenseDocumentType> defenseDocumentTypes) {
        this.defenseDocumentTypes = defenseDocumentTypes;
    }

    public DefenseReason defenseReasonCode(String defenseReasonCode) {
        this.defenseReasonCode = defenseReasonCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The defense reason code that was selected to defend this dispute.")
    @JsonProperty(value="defenseReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefenseReasonCode() {
        return this.defenseReasonCode;
    }

    @JsonProperty(value="defenseReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefenseReasonCode(String defenseReasonCode) {
        this.defenseReasonCode = defenseReasonCode;
    }

    public DefenseReason satisfied(Boolean satisfied) {
        this.satisfied = satisfied;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if sufficient defense material has been supplied.")
    @JsonProperty(value="satisfied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSatisfied() {
        return this.satisfied;
    }

    @JsonProperty(value="satisfied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSatisfied(Boolean satisfied) {
        this.satisfied = satisfied;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefenseReason defenseReason = (DefenseReason)o;
        return Objects.equals(this.defenseDocumentTypes, defenseReason.defenseDocumentTypes) && Objects.equals(this.defenseReasonCode, defenseReason.defenseReasonCode) && Objects.equals(this.satisfied, defenseReason.satisfied);
    }

    public int hashCode() {
        return Objects.hash(this.defenseDocumentTypes, this.defenseReasonCode, this.satisfied);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DefenseReason {\n");
        sb.append("    defenseDocumentTypes: ").append(this.toIndentedString(this.defenseDocumentTypes)).append("\n");
        sb.append("    defenseReasonCode: ").append(this.toIndentedString(this.defenseReasonCode)).append("\n");
        sb.append("    satisfied: ").append(this.toIndentedString(this.satisfied)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DefenseReason fromJson(String jsonString) throws JsonProcessingException {
        return (DefenseReason)JSON.getMapper().readValue(jsonString, DefenseReason.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

