/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AccountHolderCapability;
import com.adyen.model.balanceplatform.ContactDetails;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"balancePlatform", "capabilities", "contactDetails", "description", "legalEntityId", "metadata", "migratedAccountHolderCode", "reference", "timeZone"})
public class AccountHolderInfo {
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, AccountHolderCapability> capabilities = null;
    public static final String JSON_PROPERTY_CONTACT_DETAILS = "contactDetails";
    @Deprecated
    private ContactDetails contactDetails;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_MIGRATED_ACCOUNT_HOLDER_CODE = "migratedAccountHolderCode";
    private String migratedAccountHolderCode;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_TIME_ZONE = "timeZone";
    private String timeZone;

    public AccountHolderInfo balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [balance platform](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balancePlatforms/{id}__queryParam_id) to which the account holder belongs. Required in the request if your API credentials can be used for multiple balance platforms.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public AccountHolderInfo capabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public AccountHolderInfo putCapabilitiesItem(String key, AccountHolderCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, AccountHolderCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that an account holder can do in your platform. The key is a capability required for your integration. For example, **issueCard** for Issuing. The value is an object containing the settings for the capability.")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, AccountHolderCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
    }

    @Deprecated
    public AccountHolderInfo contactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="")
    @JsonProperty(value="contactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactDetails getContactDetails() {
        return this.contactDetails;
    }

    @Deprecated
    @JsonProperty(value="contactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
    }

    public AccountHolderInfo description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the account holder.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AccountHolderInfo legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id) associated with the account holder. Adyen performs a verification process against the legal entity of the account holder.")
    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public AccountHolderInfo metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public AccountHolderInfo putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public AccountHolderInfo migratedAccountHolderCode(String migratedAccountHolderCode) {
        this.migratedAccountHolderCode = migratedAccountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the migrated account holder in the classic integration.")
    @JsonProperty(value="migratedAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMigratedAccountHolderCode() {
        return this.migratedAccountHolderCode;
    }

    @JsonProperty(value="migratedAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigratedAccountHolderCode(String migratedAccountHolderCode) {
        this.migratedAccountHolderCode = migratedAccountHolderCode;
    }

    public AccountHolderInfo reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the account holder.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public AccountHolderInfo timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the account holder. For example, **Europe/Amsterdam**. Defaults to the time zone of the balance platform if no time zone is set. For possible values, see the [list of time zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).")
    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderInfo accountHolderInfo = (AccountHolderInfo)o;
        return Objects.equals(this.balancePlatform, accountHolderInfo.balancePlatform) && Objects.equals(this.capabilities, accountHolderInfo.capabilities) && Objects.equals(this.contactDetails, accountHolderInfo.contactDetails) && Objects.equals(this.description, accountHolderInfo.description) && Objects.equals(this.legalEntityId, accountHolderInfo.legalEntityId) && Objects.equals(this.metadata, accountHolderInfo.metadata) && Objects.equals(this.migratedAccountHolderCode, accountHolderInfo.migratedAccountHolderCode) && Objects.equals(this.reference, accountHolderInfo.reference) && Objects.equals(this.timeZone, accountHolderInfo.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.balancePlatform, this.capabilities, this.contactDetails, this.description, this.legalEntityId, this.metadata, this.migratedAccountHolderCode, this.reference, this.timeZone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderInfo {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    contactDetails: ").append(this.toIndentedString(this.contactDetails)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    migratedAccountHolderCode: ").append(this.toIndentedString(this.migratedAccountHolderCode)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderInfo fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderInfo)JSON.getMapper().readValue(jsonString, AccountHolderInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

