/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"modificationMerchantReference", "modificationPspReference", "paymentMerchantReference", "platformPaymentType", "pspPaymentReference", "type"})
public class PlatformPayment {
    public static final String JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE = "modificationMerchantReference";
    private String modificationMerchantReference;
    public static final String JSON_PROPERTY_MODIFICATION_PSP_REFERENCE = "modificationPspReference";
    private String modificationPspReference;
    public static final String JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE = "paymentMerchantReference";
    private String paymentMerchantReference;
    public static final String JSON_PROPERTY_PLATFORM_PAYMENT_TYPE = "platformPaymentType";
    private PlatformPaymentTypeEnum platformPaymentType;
    public static final String JSON_PROPERTY_PSP_PAYMENT_REFERENCE = "pspPaymentReference";
    private String pspPaymentReference;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public PlatformPayment modificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The capture's merchant reference included in the transfer.")
    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationMerchantReference() {
        return this.modificationMerchantReference;
    }

    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
    }

    public PlatformPayment modificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
        return this;
    }

    @ApiModelProperty(value="The capture reference included in the transfer.")
    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationPspReference() {
        return this.modificationPspReference;
    }

    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
    }

    public PlatformPayment paymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The payment's merchant reference included in the transfer.")
    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMerchantReference() {
        return this.paymentMerchantReference;
    }

    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
    }

    public PlatformPayment platformPaymentType(PlatformPaymentTypeEnum platformPaymentType) {
        this.platformPaymentType = platformPaymentType;
        return this;
    }

    @ApiModelProperty(value="Specifies the nature of the transfer. This parameter helps categorize transfers so you can reconcile transactions at a later time, using the Balance Platform Accounting Report for [marketplaces](https://docs.adyen.com/marketplaces/reports-and-fees/balance-platform-accounting-report/) or [platforms](https://docs.adyen.com/platforms/reports-and-fees/balance-platform-accounting-report/).  Possible values:  * **AcquiringFees**: for the acquiring fee incurred on a transaction.  * **AdyenCommission**: for the transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/guides/payments-training-guide/get-the-best-from-your-card-processing).  * **AdyenFees**: for all the transaction fees due to Adyen. This is the sum of Adyen's commission and Adyen's markup.  * **AdyenMarkup**: for the transaction fee due to Adyen under [Interchange++ pricing](https://www.adyen.com/pricing).  * **BalanceAccount**: or the sale amount of a transaction.  * **Commission**: for your platform's commission on a transaction.  * **Interchange**: for the interchange fee (fee paid to the issuer) incurred on a transaction.  * **PaymentFee**: for all of the transaction fees.  * **Remainder**: for the left over amount after currency conversion.  * **SchemeFee**: for the scheme fee incurred on a transaction. This is the sum of the interchange fees and the acquiring fees.  * **Surcharge**: for the surcharge paid by the customer on a transaction.  * **Tip**: for the tip paid by the customer.  * **TopUp**: for an incoming transfer to top up your user's balance account.  * **VAT**: for the Value Added Tax.")
    @JsonProperty(value="platformPaymentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformPaymentTypeEnum getPlatformPaymentType() {
        return this.platformPaymentType;
    }

    @JsonProperty(value="platformPaymentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformPaymentType(PlatformPaymentTypeEnum platformPaymentType) {
        this.platformPaymentType = platformPaymentType;
    }

    public PlatformPayment pspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
        return this;
    }

    @ApiModelProperty(value="The payment reference included in the transfer.")
    @JsonProperty(value="pspPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspPaymentReference() {
        return this.pspPaymentReference;
    }

    @JsonProperty(value="pspPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
    }

    public PlatformPayment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="**platformPayment**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformPayment platformPayment = (PlatformPayment)o;
        return Objects.equals(this.modificationMerchantReference, platformPayment.modificationMerchantReference) && Objects.equals(this.modificationPspReference, platformPayment.modificationPspReference) && Objects.equals(this.paymentMerchantReference, platformPayment.paymentMerchantReference) && Objects.equals((Object)this.platformPaymentType, (Object)platformPayment.platformPaymentType) && Objects.equals(this.pspPaymentReference, platformPayment.pspPaymentReference) && Objects.equals((Object)this.type, (Object)platformPayment.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modificationMerchantReference, this.modificationPspReference, this.paymentMerchantReference, this.platformPaymentType, this.pspPaymentReference, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlatformPayment {\n");
        sb.append("    modificationMerchantReference: ").append(this.toIndentedString(this.modificationMerchantReference)).append("\n");
        sb.append("    modificationPspReference: ").append(this.toIndentedString(this.modificationPspReference)).append("\n");
        sb.append("    paymentMerchantReference: ").append(this.toIndentedString(this.paymentMerchantReference)).append("\n");
        sb.append("    platformPaymentType: ").append(this.toIndentedString((Object)this.platformPaymentType)).append("\n");
        sb.append("    pspPaymentReference: ").append(this.toIndentedString(this.pspPaymentReference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PlatformPayment fromJson(String jsonString) throws JsonProcessingException {
        return (PlatformPayment)JSON.getMapper().readValue(jsonString, PlatformPayment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PlatformPaymentTypeEnum {
        ACQUIRINGFEES("AcquiringFees"),
        ADYENCOMMISSION("AdyenCommission"),
        ADYENFEES("AdyenFees"),
        ADYENMARKUP("AdyenMarkup"),
        BALANCEACCOUNT("BalanceAccount"),
        COMMISSION("Commission"),
        DEFAULT("Default"),
        INTERCHANGE("Interchange"),
        PAYMENTFEE("PaymentFee"),
        REMAINDER("Remainder"),
        SCHEMEFEE("SchemeFee"),
        SURCHARGE("Surcharge"),
        TIP("Tip"),
        TOPUP("TopUp"),
        VAT("VAT");

        private String value;

        private PlatformPaymentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlatformPaymentTypeEnum fromValue(String value) {
            for (PlatformPaymentTypeEnum b : PlatformPaymentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

