/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "bankAccountUUID", "description", "documentType", "filename", "legalArrangementCode", "legalArrangementEntityCode", "shareholderCode", "signatoryCode"})
public class DocumentDetail {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
    private String bankAccountUUID;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DOCUMENT_TYPE = "documentType";
    private DocumentTypeEnum documentType;
    public static final String JSON_PROPERTY_FILENAME = "filename";
    private String filename;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
    private String legalArrangementCode;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE = "legalArrangementEntityCode";
    private String legalArrangementEntityCode;
    public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
    private String shareholderCode;
    public static final String JSON_PROPERTY_SIGNATORY_CODE = "signatoryCode";
    private String signatoryCode;

    public DocumentDetail accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of account holder, to which the document applies.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public DocumentDetail bankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
        return this;
    }

    @ApiModelProperty(value="The Adyen-generated [`bankAccountUUID`](https://docs.adyen.com/api-explorer/#/Account/latest/post/createAccountHolder__resParam_accountHolderDetails-bankAccountDetails-bankAccountUUID) to which the document must be linked. Refer to [Bank account check](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/bank-account-check#uploading-a-bank-statement) for details on when a document should be submitted. >Required if the `documentType` is **BANK_STATEMENT**, where a document is being submitted in order to verify a bank account. ")
    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountUUID() {
        return this.bankAccountUUID;
    }

    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
    }

    public DocumentDetail description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the document.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public DocumentDetail documentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the document. Refer to [Verification checks](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks) for details on when each document type should be submitted and for the accepted file formats.  Permitted values: * **BANK_STATEMENT**: A file containing a bank statement or other document proving ownership of a specific bank account. * **COMPANY_REGISTRATION_SCREENING** (Supported from v5 and later): A file containing a company registration document. * **CONSTITUTIONAL_DOCUMENT**: A file containing information about the account holder's legal arrangement. * **PASSPORT**: A file containing the identity page(s) of a passport. * **ID_CARD_FRONT**: A file containing only the front of the ID card. In order for a document to be usable, both the **ID_CARD_FRONT** and **ID_CARD_BACK** must be submitted. * **ID_CARD_BACK**: A file containing only the back of the ID card. In order for a document to be usable, both the **ID_CARD_FRONT** and **ID_CARD_BACK** must be submitted. * **DRIVING_LICENCE_FRONT**: A file containing only the front of the driving licence. In order for a document to be usable, both the **DRIVING_LICENCE_FRONT** and **DRIVING_LICENCE_BACK** must be submitted. * **DRIVING_LICENCE_BACK**: A file containing only the back of the driving licence. In order for a document to be usable, both the **DRIVING_LICENCE_FRONT** and **DRIVING_LICENCE_FRONT** must be submitted. ")
    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocumentTypeEnum getDocumentType() {
        return this.documentType;
    }

    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
    }

    public DocumentDetail filename(String filename) {
        this.filename = filename;
        return this;
    }

    @ApiModelProperty(value="Filename of the document.")
    @JsonProperty(value="filename")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="filename")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DocumentDetail legalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
        return this;
    }

    @ApiModelProperty(value="The Adyen-generated [`legalArrangementCode`](https://docs.adyen.com/api-explorer/#/Account/latest/post/createAccountHolder__resParam_accountHolderDetails-legalArrangements-legalArrangementCode) to which the document must be linked.")
    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementCode() {
        return this.legalArrangementCode;
    }

    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
    }

    public DocumentDetail legalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
        return this;
    }

    @ApiModelProperty(value="The Adyen-generated [`legalArrangementEntityCode`](https://docs.adyen.com/api-explorer/#/Account/v6/post/createAccountHolder__resParam_accountHolderDetails-legalArrangements-legalArrangementEntities-legalArrangementEntityCode)  to which the document must be linked.")
    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementEntityCode() {
        return this.legalArrangementEntityCode;
    }

    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
    }

    public DocumentDetail shareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
        return this;
    }

    @ApiModelProperty(value="The Adyen-generated [`shareholderCode`](https://docs.adyen.com/api-explorer/#/Account/latest/post/createAccountHolder__resParam_accountHolderDetails-businessDetails-shareholders-shareholderCode) to which the document must be linked. Refer to [Verification checks](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks) for details on when a document should be submitted. >Required if the account holder has a `legalEntity` of type **Business** and the `documentType` is either **PASSPORT**, **ID_CARD_FRONT**, **ID_CARD_BACK**, **DRIVING_LICENCE_FRONT**, or **DRIVING_LICENCE_BACK**. ")
    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShareholderCode() {
        return this.shareholderCode;
    }

    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
    }

    public DocumentDetail signatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
        return this;
    }

    @ApiModelProperty(value="The Adyen-generated [`signatoryCode`](https://docs.adyen.com/api-explorer/#/Account/v6/post/createAccountHolder__resParam_accountHolderDetails-businessDetails-signatories-signatoryCode) to which the document must be linked.")
    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignatoryCode() {
        return this.signatoryCode;
    }

    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentDetail documentDetail = (DocumentDetail)o;
        return Objects.equals(this.accountHolderCode, documentDetail.accountHolderCode) && Objects.equals(this.bankAccountUUID, documentDetail.bankAccountUUID) && Objects.equals(this.description, documentDetail.description) && Objects.equals((Object)this.documentType, (Object)documentDetail.documentType) && Objects.equals(this.filename, documentDetail.filename) && Objects.equals(this.legalArrangementCode, documentDetail.legalArrangementCode) && Objects.equals(this.legalArrangementEntityCode, documentDetail.legalArrangementEntityCode) && Objects.equals(this.shareholderCode, documentDetail.shareholderCode) && Objects.equals(this.signatoryCode, documentDetail.signatoryCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.bankAccountUUID, this.description, this.documentType, this.filename, this.legalArrangementCode, this.legalArrangementEntityCode, this.shareholderCode, this.signatoryCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentDetail {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    bankAccountUUID: ").append(this.toIndentedString(this.bankAccountUUID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    legalArrangementCode: ").append(this.toIndentedString(this.legalArrangementCode)).append("\n");
        sb.append("    legalArrangementEntityCode: ").append(this.toIndentedString(this.legalArrangementEntityCode)).append("\n");
        sb.append("    shareholderCode: ").append(this.toIndentedString(this.shareholderCode)).append("\n");
        sb.append("    signatoryCode: ").append(this.toIndentedString(this.signatoryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DocumentDetail fromJson(String jsonString) throws JsonProcessingException {
        return (DocumentDetail)JSON.getMapper().readValue(jsonString, DocumentDetail.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum DocumentTypeEnum {
        BANK_STATEMENT("BANK_STATEMENT"),
        BSN("BSN"),
        COMPANY_REGISTRATION_SCREENING("COMPANY_REGISTRATION_SCREENING"),
        CONSTITUTIONAL_DOCUMENT("CONSTITUTIONAL_DOCUMENT"),
        DRIVING_LICENCE("DRIVING_LICENCE"),
        DRIVING_LICENCE_BACK("DRIVING_LICENCE_BACK"),
        DRIVING_LICENCE_FRONT("DRIVING_LICENCE_FRONT"),
        ID_CARD("ID_CARD"),
        ID_CARD_BACK("ID_CARD_BACK"),
        ID_CARD_FRONT("ID_CARD_FRONT"),
        PASSPORT("PASSPORT"),
        PROOF_OF_RESIDENCY("PROOF_OF_RESIDENCY"),
        SSN("SSN"),
        SUPPORTING_DOCUMENTS("SUPPORTING_DOCUMENTS");

        private String value;

        private DocumentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DocumentTypeEnum fromValue(String value) {
            for (DocumentTypeEnum b : DocumentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

