/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"pciTemplateReferences", "signedBy"})
public class PciSigningRequest {
    public static final String JSON_PROPERTY_PCI_TEMPLATE_REFERENCES = "pciTemplateReferences";
    private List<String> pciTemplateReferences = new ArrayList<String>();
    public static final String JSON_PROPERTY_SIGNED_BY = "signedBy";
    private String signedBy;

    public PciSigningRequest pciTemplateReferences(List<String> pciTemplateReferences) {
        this.pciTemplateReferences = pciTemplateReferences;
        return this;
    }

    public PciSigningRequest addPciTemplateReferencesItem(String pciTemplateReferencesItem) {
        this.pciTemplateReferences.add(pciTemplateReferencesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The array of Adyen-generated unique identifiers for the questionnaires.")
    @JsonProperty(value="pciTemplateReferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPciTemplateReferences() {
        return this.pciTemplateReferences;
    }

    @JsonProperty(value="pciTemplateReferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPciTemplateReferences(List<String> pciTemplateReferences) {
        this.pciTemplateReferences = pciTemplateReferences;
    }

    public PciSigningRequest signedBy(String signedBy) {
        this.signedBy = signedBy;
        return this;
    }

    @ApiModelProperty(required=true, value="The [legal entity ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) of the individual who signs the PCI questionnaire.")
    @JsonProperty(value="signedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignedBy() {
        return this.signedBy;
    }

    @JsonProperty(value="signedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignedBy(String signedBy) {
        this.signedBy = signedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PciSigningRequest pciSigningRequest = (PciSigningRequest)o;
        return Objects.equals(this.pciTemplateReferences, pciSigningRequest.pciTemplateReferences) && Objects.equals(this.signedBy, pciSigningRequest.signedBy);
    }

    public int hashCode() {
        return Objects.hash(this.pciTemplateReferences, this.signedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PciSigningRequest {\n");
        sb.append("    pciTemplateReferences: ").append(this.toIndentedString(this.pciTemplateReferences)).append("\n");
        sb.append("    signedBy: ").append(this.toIndentedString(this.signedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PciSigningRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PciSigningRequest)JSON.getMapper().readValue(jsonString, PciSigningRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

