/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.CheckoutOrderResponse;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentResponseAction;
import com.adyen.model.checkout.ResponsePaymentMethod;
import com.adyen.model.checkout.ThreeDS2ResponseData;
import com.adyen.model.checkout.ThreeDS2Result;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"action", "additionalData", "amount", "donationToken", "fraudResult", "merchantReference", "order", "paymentMethod", "pspReference", "refusalReason", "refusalReasonCode", "resultCode", "threeDS2ResponseData", "threeDS2Result", "threeDSPaymentData"})
public class PaymentResponse {
    public static final String JSON_PROPERTY_ACTION = "action";
    private PaymentResponseAction action;
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DONATION_TOKEN = "donationToken";
    private String donationToken;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_ORDER = "order";
    private CheckoutOrderResponse order;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private ResponsePaymentMethod paymentMethod;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_REFUSAL_REASON_CODE = "refusalReasonCode";
    private String refusalReasonCode;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    public static final String JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA = "threeDS2ResponseData";
    private ThreeDS2ResponseData threeDS2ResponseData;
    public static final String JSON_PROPERTY_THREE_D_S2_RESULT = "threeDS2Result";
    private ThreeDS2Result threeDS2Result;
    public static final String JSON_PROPERTY_THREE_D_S_PAYMENT_DATA = "threeDSPaymentData";
    private String threeDSPaymentData;

    public PaymentResponse action(PaymentResponseAction action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentResponseAction getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAction(PaymentResponseAction action) {
        this.action = action;
    }

    public PaymentResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentResponse donationToken(String donationToken) {
        this.donationToken = donationToken;
        return this;
    }

    @ApiModelProperty(value="Donation Token containing payment details for Adyen Giving.")
    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationToken() {
        return this.donationToken;
    }

    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationToken(String donationToken) {
        this.donationToken = donationToken;
    }

    public PaymentResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PaymentResponse merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public PaymentResponse order(CheckoutOrderResponse order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckoutOrderResponse getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(CheckoutOrderResponse order) {
        this.order = order;
    }

    public PaymentResponse paymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponsePaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character string reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.  > For payment methods that require a redirect or additional action, you will get this value in the `/payments/details` response.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PaymentResponse refusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
        return this;
    }

    @ApiModelProperty(value="Code that specifies the refusal reason. For more information, see [Authorisation refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReasonCode() {
        return this.refusalReasonCode;
    }

    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
    }

    public PaymentResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result of the payment. For more information, see [Result codes](https://docs.adyen.com/online-payments/payment-result-codes).  Possible values:  * **AuthenticationFinished** \u2013 The payment has been successfully authenticated with 3D Secure 2. Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** \u2013 The transaction does not require 3D Secure authentication. Returned for [standalone authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). * **Authorised** \u2013 The payment was successfully authorised. This state serves as an indicator to proceed with the delivery of goods and services. This is a final state. * **Cancelled** \u2013 Indicates the payment has been cancelled (either by the shopper or the merchant) before processing was completed. This is a final state. * **ChallengeShopper** \u2013 The issuer requires further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Error** \u2013 There was an error when the payment was being processed. The reason is given in the `refusalReason` field. This is a final state. * **IdentifyShopper** \u2013 The issuer requires the shopper's device fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** \u2013 The payment has been authorised for a partial amount. This happens for card payments when the merchant supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** \u2013 Indicates that it is not possible to obtain the final status of the payment. This can happen if the systems providing final status information for the payment are unavailable, or if the shopper needs to take further action to complete the payment. * **PresentToShopper** \u2013 Indicates that the response contains additional information that you need to present to a shopper, so that they can use it to complete a payment. * **Received** \u2013 Indicates the payment has successfully been received by Adyen, and will be processed. This is the initial state for all payments. * **RedirectShopper** \u2013 Indicates the shopper should be redirected to an external web page or app to complete the authorisation. * **Refused** \u2013 Indicates the payment was refused. The reason is given in the `refusalReason` field. This is a final state.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public PaymentResponse threeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="threeDS2ResponseData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2ResponseData getThreeDS2ResponseData() {
        return this.threeDS2ResponseData;
    }

    @JsonProperty(value="threeDS2ResponseData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
    }

    public PaymentResponse threeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="threeDS2Result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2Result getThreeDS2Result() {
        return this.threeDS2Result;
    }

    @JsonProperty(value="threeDS2Result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
    }

    public PaymentResponse threeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
        return this;
    }

    @ApiModelProperty(value="When non-empty, contains a value that you must submit to the `/payments/details` endpoint as `paymentData`.")
    @JsonProperty(value="threeDSPaymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSPaymentData() {
        return this.threeDSPaymentData;
    }

    @JsonProperty(value="threeDSPaymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResponse paymentResponse = (PaymentResponse)o;
        return Objects.equals(this.action, paymentResponse.action) && Objects.equals(this.additionalData, paymentResponse.additionalData) && Objects.equals(this.amount, paymentResponse.amount) && Objects.equals(this.donationToken, paymentResponse.donationToken) && Objects.equals(this.fraudResult, paymentResponse.fraudResult) && Objects.equals(this.merchantReference, paymentResponse.merchantReference) && Objects.equals(this.order, paymentResponse.order) && Objects.equals(this.paymentMethod, paymentResponse.paymentMethod) && Objects.equals(this.pspReference, paymentResponse.pspReference) && Objects.equals(this.refusalReason, paymentResponse.refusalReason) && Objects.equals(this.refusalReasonCode, paymentResponse.refusalReasonCode) && Objects.equals((Object)this.resultCode, (Object)paymentResponse.resultCode) && Objects.equals(this.threeDS2ResponseData, paymentResponse.threeDS2ResponseData) && Objects.equals(this.threeDS2Result, paymentResponse.threeDS2Result) && Objects.equals(this.threeDSPaymentData, paymentResponse.threeDSPaymentData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.additionalData, this.amount, this.donationToken, this.fraudResult, this.merchantReference, this.order, this.paymentMethod, this.pspReference, this.refusalReason, this.refusalReasonCode, this.resultCode, this.threeDS2ResponseData, this.threeDS2Result, this.threeDSPaymentData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResponse {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    donationToken: ").append(this.toIndentedString(this.donationToken)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    refusalReasonCode: ").append(this.toIndentedString(this.refusalReasonCode)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    threeDS2ResponseData: ").append(this.toIndentedString(this.threeDS2ResponseData)).append("\n");
        sb.append("    threeDS2Result: ").append(this.toIndentedString(this.threeDS2Result)).append("\n");
        sb.append("    threeDSPaymentData: ").append(this.toIndentedString(this.threeDSPaymentData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentResponse)JSON.getMapper().readValue(jsonString, PaymentResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED("AuthenticationFinished"),
        AUTHENTICATIONNOTREQUIRED("AuthenticationNotRequired"),
        AUTHORISED("Authorised"),
        CANCELLED("Cancelled"),
        CHALLENGESHOPPER("ChallengeShopper"),
        ERROR("Error"),
        IDENTIFYSHOPPER("IdentifyShopper"),
        PARTIALLYAUTHORISED("PartiallyAuthorised"),
        PENDING("Pending"),
        PRESENTTOSHOPPER("PresentToShopper"),
        RECEIVED("Received"),
        REDIRECTSHOPPER("RedirectShopper"),
        REFUSED("Refused"),
        SUCCESS("Success");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

