/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "applicationInfo", "lineItems", "merchantAccount", "merchantRefundReason", "reference", "splits", "store"})
public class PaymentRefundRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_REFUND_REASON = "merchantRefundReason";
    private MerchantRefundReasonEnum merchantRefundReason;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = null;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public PaymentRefundRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentRefundRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentRefundRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentRefundRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="Price and product information of the refunded items, required for [partial refunds](https://docs.adyen.com/online-payments/refund#refund-a-payment). > This field is required for partial refunds with 3x 4x Oney, Affirm, Afterpay, Atome, Clearpay, Klarna, Ratepay, Walley, and Zip.")
    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentRefundRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentRefundRequest merchantRefundReason(MerchantRefundReasonEnum merchantRefundReason) {
        this.merchantRefundReason = merchantRefundReason;
        return this;
    }

    @ApiModelProperty(value="Your reason for the refund request")
    @JsonProperty(value="merchantRefundReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantRefundReasonEnum getMerchantRefundReason() {
        return this.merchantRefundReason;
    }

    @JsonProperty(value="merchantRefundReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantRefundReason(MerchantRefundReasonEnum merchantRefundReason) {
        this.merchantRefundReason = merchantRefundReason;
    }

    public PaymentRefundRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the refund request. Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentRefundRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentRefundRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For more information, see how to process payments for [marketplaces](https://docs.adyen.com/marketplaces/split-payments) or [platforms](https://docs.adyen.com/platforms/online-payments/split-payments/).")
    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentRefundRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The online store or [physical store](https://docs.adyen.com/point-of-sale/design-your-integration/determine-account-structure/#create-stores) that is processing the refund. This must be the same as the store name configured in your Customer Area.  Otherwise, you get an error and the refund fails.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRefundRequest paymentRefundRequest = (PaymentRefundRequest)o;
        return Objects.equals(this.amount, paymentRefundRequest.amount) && Objects.equals(this.applicationInfo, paymentRefundRequest.applicationInfo) && Objects.equals(this.lineItems, paymentRefundRequest.lineItems) && Objects.equals(this.merchantAccount, paymentRefundRequest.merchantAccount) && Objects.equals((Object)this.merchantRefundReason, (Object)paymentRefundRequest.merchantRefundReason) && Objects.equals(this.reference, paymentRefundRequest.reference) && Objects.equals(this.splits, paymentRefundRequest.splits) && Objects.equals(this.store, paymentRefundRequest.store);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.applicationInfo, this.lineItems, this.merchantAccount, this.merchantRefundReason, this.reference, this.splits, this.store});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRefundRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantRefundReason: ").append(this.toIndentedString((Object)this.merchantRefundReason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentRefundRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentRefundRequest)JSON.getMapper().readValue(jsonString, PaymentRefundRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum MerchantRefundReasonEnum {
        FRAUD("FRAUD"),
        CUSTOMER_REQUEST("CUSTOMER REQUEST"),
        RETURN("RETURN"),
        DUPLICATE("DUPLICATE"),
        OTHER("OTHER");

        private String value;

        private MerchantRefundReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MerchantRefundReasonEnum fromValue(String value) {
            for (MerchantRefundReasonEnum b : MerchantRefundReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

