/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"allowCustomAmount", "currency", "predefinedTipEntries", "usePredefinedTipEntries"})
public class Gratuity {
    public static final String JSON_PROPERTY_ALLOW_CUSTOM_AMOUNT = "allowCustomAmount";
    private Boolean allowCustomAmount;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_PREDEFINED_TIP_ENTRIES = "predefinedTipEntries";
    private List<String> predefinedTipEntries = null;
    public static final String JSON_PROPERTY_USE_PREDEFINED_TIP_ENTRIES = "usePredefinedTipEntries";
    private Boolean usePredefinedTipEntries;

    public Gratuity allowCustomAmount(Boolean allowCustomAmount) {
        this.allowCustomAmount = allowCustomAmount;
        return this;
    }

    @ApiModelProperty(value="Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in `predefinedTipEntries` are shown.")
    @JsonProperty(value="allowCustomAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowCustomAmount() {
        return this.allowCustomAmount;
    }

    @JsonProperty(value="allowCustomAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowCustomAmount(Boolean allowCustomAmount) {
        this.allowCustomAmount = allowCustomAmount;
    }

    public Gratuity currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency that the tipping settings apply to.")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Gratuity predefinedTipEntries(List<String> predefinedTipEntries) {
        this.predefinedTipEntries = predefinedTipEntries;
        return this;
    }

    public Gratuity addPredefinedTipEntriesItem(String predefinedTipEntriesItem) {
        if (this.predefinedTipEntries == null) {
            this.predefinedTipEntries = new ArrayList<String>();
        }
        this.predefinedTipEntries.add(predefinedTipEntriesItem);
        return this;
    }

    @ApiModelProperty(value="Tipping options the shopper can choose from if `usePredefinedTipEntries` is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.")
    @JsonProperty(value="predefinedTipEntries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPredefinedTipEntries() {
        return this.predefinedTipEntries;
    }

    @JsonProperty(value="predefinedTipEntries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPredefinedTipEntries(List<String> predefinedTipEntries) {
        this.predefinedTipEntries = predefinedTipEntries;
    }

    public Gratuity usePredefinedTipEntries(Boolean usePredefinedTipEntries) {
        this.usePredefinedTipEntries = usePredefinedTipEntries;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).")
    @JsonProperty(value="usePredefinedTipEntries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUsePredefinedTipEntries() {
        return this.usePredefinedTipEntries;
    }

    @JsonProperty(value="usePredefinedTipEntries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsePredefinedTipEntries(Boolean usePredefinedTipEntries) {
        this.usePredefinedTipEntries = usePredefinedTipEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gratuity gratuity = (Gratuity)o;
        return Objects.equals(this.allowCustomAmount, gratuity.allowCustomAmount) && Objects.equals(this.currency, gratuity.currency) && Objects.equals(this.predefinedTipEntries, gratuity.predefinedTipEntries) && Objects.equals(this.usePredefinedTipEntries, gratuity.usePredefinedTipEntries);
    }

    public int hashCode() {
        return Objects.hash(this.allowCustomAmount, this.currency, this.predefinedTipEntries, this.usePredefinedTipEntries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Gratuity {\n");
        sb.append("    allowCustomAmount: ").append(this.toIndentedString(this.allowCustomAmount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    predefinedTipEntries: ").append(this.toIndentedString(this.predefinedTipEntries)).append("\n");
        sb.append("    usePredefinedTipEntries: ").append(this.toIndentedString(this.usePredefinedTipEntries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Gratuity fromJson(String jsonString) throws JsonProcessingException {
        return (Gratuity)JSON.getMapper().readValue(jsonString, Gratuity.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

