/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"checkoutAttemptId", "firstName", "lastName", "shopperEmail", "type"})
public class DokuDetails {
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public DokuDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public DokuDetails firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopper's first name.")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public DokuDetails lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopper's last name.")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public DokuDetails shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopper's email.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public DokuDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**doku**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DokuDetails dokuDetails = (DokuDetails)o;
        return Objects.equals(this.checkoutAttemptId, dokuDetails.checkoutAttemptId) && Objects.equals(this.firstName, dokuDetails.firstName) && Objects.equals(this.lastName, dokuDetails.lastName) && Objects.equals(this.shopperEmail, dokuDetails.shopperEmail) && Objects.equals((Object)this.type, (Object)dokuDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkoutAttemptId, this.firstName, this.lastName, this.shopperEmail, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DokuDetails {\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DokuDetails fromJson(String jsonString) throws JsonProcessingException {
        return (DokuDetails)JSON.getMapper().readValue(jsonString, DokuDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        MANDIRI_VA("doku_mandiri_va"),
        CIMB_VA("doku_cimb_va"),
        DANAMON_VA("doku_danamon_va"),
        BNI_VA("doku_bni_va"),
        PERMATA_LITE_ATM("doku_permata_lite_atm"),
        BRI_VA("doku_bri_va"),
        BCA_VA("doku_bca_va"),
        ALFAMART("doku_alfamart"),
        INDOMARET("doku_indomaret"),
        WALLET("doku_wallet"),
        OVO("doku_ovo");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

