/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.TransactionRuleEntityKey;
import com.adyen.model.balanceplatform.TransactionRuleInterval;
import com.adyen.model.balanceplatform.TransactionRuleRestrictions;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregationLevel", "description", "endDate", "entityKey", "id", "interval", "outcomeType", "reference", "requestType", "ruleRestrictions", "score", "startDate", "status", "type"})
public class TransactionRule {
    public static final String JSON_PROPERTY_AGGREGATION_LEVEL = "aggregationLevel";
    private String aggregationLevel;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private String endDate;
    public static final String JSON_PROPERTY_ENTITY_KEY = "entityKey";
    private TransactionRuleEntityKey entityKey;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private TransactionRuleInterval interval;
    public static final String JSON_PROPERTY_OUTCOME_TYPE = "outcomeType";
    private OutcomeTypeEnum outcomeType;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    private RequestTypeEnum requestType;
    public static final String JSON_PROPERTY_RULE_RESTRICTIONS = "ruleRestrictions";
    private TransactionRuleRestrictions ruleRestrictions;
    public static final String JSON_PROPERTY_SCORE = "score";
    private Integer score;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private String startDate;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public TransactionRule aggregationLevel(String aggregationLevel) {
        this.aggregationLevel = aggregationLevel;
        return this;
    }

    @ApiModelProperty(value="The level at which data must be accumulated, used in rules with `type` **velocity** or **maxUsage**. The level must be the [same or lower in hierarchy](https://docs.adyen.com/issuing/transaction-rules#accumulate-data) than the `entityKey`.  If not provided, by default, the rule will accumulate data at the **paymentInstrument** level.  Possible values: **paymentInstrument**, **paymentInstrumentGroup**, **balanceAccount**, **accountHolder**, **balancePlatform**.")
    @JsonProperty(value="aggregationLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAggregationLevel() {
        return this.aggregationLevel;
    }

    @JsonProperty(value="aggregationLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregationLevel(String aggregationLevel) {
        this.aggregationLevel = aggregationLevel;
    }

    public TransactionRule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Your description for the transaction rule.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public TransactionRule endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="The date when the rule will stop being evaluated, in ISO 8601 extended offset date-time format. For example, **2020-12-18T10:15:30+01:00**.  If not provided, the rule will be evaluated until the rule status is set to **inactive**.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public TransactionRule entityKey(TransactionRuleEntityKey entityKey) {
        this.entityKey = entityKey;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="entityKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionRuleEntityKey getEntityKey() {
        return this.entityKey;
    }

    @JsonProperty(value="entityKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityKey(TransactionRuleEntityKey entityKey) {
        this.entityKey = entityKey;
    }

    public TransactionRule id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the transaction rule.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TransactionRule interval(TransactionRuleInterval interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionRuleInterval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInterval(TransactionRuleInterval interval) {
        this.interval = interval;
    }

    public TransactionRule outcomeType(OutcomeTypeEnum outcomeType) {
        this.outcomeType = outcomeType;
        return this;
    }

    @ApiModelProperty(value="The [outcome](https://docs.adyen.com/issuing/transaction-rules#outcome) that will be applied when a transaction meets the conditions of the rule.  Possible values: * **hardBlock**: the transaction is declined. * **scoreBased**: the transaction is assigned the `score` you specified. Adyen calculates the total score and if it exceeds 100, declines the Transaction.  Default value: **hardBlock**.  > **scoreBased** is not allowed when `requestType` is **bankTransfer**.")
    @JsonProperty(value="outcomeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OutcomeTypeEnum getOutcomeType() {
        return this.outcomeType;
    }

    @JsonProperty(value="outcomeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutcomeType(OutcomeTypeEnum outcomeType) {
        this.outcomeType = outcomeType;
    }

    public TransactionRule reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="Your reference for the transaction rule.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransactionRule requestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of request to which the rule applies. If not provided, by default, this is set to **authorization**.  Possible values: **authorization**, **authentication**, **tokenization**, **bankTransfer**.")
    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    public TransactionRule ruleRestrictions(TransactionRuleRestrictions ruleRestrictions) {
        this.ruleRestrictions = ruleRestrictions;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="ruleRestrictions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionRuleRestrictions getRuleRestrictions() {
        return this.ruleRestrictions;
    }

    @JsonProperty(value="ruleRestrictions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRuleRestrictions(TransactionRuleRestrictions ruleRestrictions) {
        this.ruleRestrictions = ruleRestrictions;
    }

    public TransactionRule score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(value="A positive or negative score applied to the transaction if it meets the conditions of the rule. Required when `outcomeType` is **scoreBased**.  The value must be between **-100** and **100**.")
    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getScore() {
        return this.score;
    }

    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScore(Integer score) {
        this.score = score;
    }

    public TransactionRule startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="The date when the rule will start to be evaluated, in ISO 8601 extended offset date-time format. For example, **2020-12-18T10:15:30+01:00**.  If not provided when creating a transaction rule, the `startDate` is set to the date when the rule status is set to **active**.   ")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public TransactionRule status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the transaction rule. If you provide a `startDate` in the request, the rule is automatically created  with an **active** status.   Possible values: **active**, **inactive**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransactionRule type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The [type of rule](https://docs.adyen.com/issuing/transaction-rules#rule-types), which defines if a rule blocks transactions based on individual characteristics or accumulates data.  Possible values:  * **blockList**: decline a transaction when the conditions are met.  * **maxUsage**: add the amount or number of transactions for the lifetime of a payment instrument, and then decline a transaction when the specified limits are met.  * **velocity**: add the amount or number of transactions based on a specified time interval, and then decline a transaction when the specified limits are met. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRule transactionRule = (TransactionRule)o;
        return Objects.equals(this.aggregationLevel, transactionRule.aggregationLevel) && Objects.equals(this.description, transactionRule.description) && Objects.equals(this.endDate, transactionRule.endDate) && Objects.equals(this.entityKey, transactionRule.entityKey) && Objects.equals(this.id, transactionRule.id) && Objects.equals(this.interval, transactionRule.interval) && Objects.equals((Object)this.outcomeType, (Object)transactionRule.outcomeType) && Objects.equals(this.reference, transactionRule.reference) && Objects.equals((Object)this.requestType, (Object)transactionRule.requestType) && Objects.equals(this.ruleRestrictions, transactionRule.ruleRestrictions) && Objects.equals(this.score, transactionRule.score) && Objects.equals(this.startDate, transactionRule.startDate) && Objects.equals((Object)this.status, (Object)transactionRule.status) && Objects.equals((Object)this.type, (Object)transactionRule.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregationLevel, this.description, this.endDate, this.entityKey, this.id, this.interval, this.outcomeType, this.reference, this.requestType, this.ruleRestrictions, this.score, this.startDate, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRule {\n");
        sb.append("    aggregationLevel: ").append(this.toIndentedString(this.aggregationLevel)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    entityKey: ").append(this.toIndentedString(this.entityKey)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    outcomeType: ").append(this.toIndentedString((Object)this.outcomeType)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    ruleRestrictions: ").append(this.toIndentedString(this.ruleRestrictions)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransactionRule fromJson(String jsonString) throws JsonProcessingException {
        return (TransactionRule)JSON.getMapper().readValue(jsonString, TransactionRule.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ALLOWLIST("allowList"),
        BLOCKLIST("blockList"),
        MAXUSAGE("maxUsage"),
        VELOCITY("velocity");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestTypeEnum {
        AUTHENTICATION("authentication"),
        AUTHORIZATION("authorization"),
        BANKTRANSFER("bankTransfer"),
        TOKENIZATION("tokenization");

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestTypeEnum fromValue(String value) {
            for (RequestTypeEnum b : RequestTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OutcomeTypeEnum {
        ENFORCESCA("enforceSCA"),
        HARDBLOCK("hardBlock"),
        SCOREBASED("scoreBased"),
        TIMEDBLOCK("timedBlock");

        private String value;

        private OutcomeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OutcomeTypeEnum fromValue(String value) {
            for (OutcomeTypeEnum b : OutcomeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

