/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.PaymentInstrument;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"hasNext", "hasPrevious", "paymentInstruments"})
public class PaginatedPaymentInstrumentsResponse {
    public static final String JSON_PROPERTY_HAS_NEXT = "hasNext";
    private Boolean hasNext;
    public static final String JSON_PROPERTY_HAS_PREVIOUS = "hasPrevious";
    private Boolean hasPrevious;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENTS = "paymentInstruments";
    private List<PaymentInstrument> paymentInstruments = new ArrayList<PaymentInstrument>();

    public PaginatedPaymentInstrumentsResponse hasNext(Boolean hasNext) {
        this.hasNext = hasNext;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the next page.")
    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasNext() {
        return this.hasNext;
    }

    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public PaginatedPaymentInstrumentsResponse hasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the previous page.")
    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPrevious() {
        return this.hasPrevious;
    }

    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    public PaginatedPaymentInstrumentsResponse paymentInstruments(List<PaymentInstrument> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
        return this;
    }

    public PaginatedPaymentInstrumentsResponse addPaymentInstrumentsItem(PaymentInstrument paymentInstrumentsItem) {
        this.paymentInstruments.add(paymentInstrumentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of payment instruments associated with the balance account.")
    @JsonProperty(value="paymentInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentInstrument> getPaymentInstruments() {
        return this.paymentInstruments;
    }

    @JsonProperty(value="paymentInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstruments(List<PaymentInstrument> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginatedPaymentInstrumentsResponse paginatedPaymentInstrumentsResponse = (PaginatedPaymentInstrumentsResponse)o;
        return Objects.equals(this.hasNext, paginatedPaymentInstrumentsResponse.hasNext) && Objects.equals(this.hasPrevious, paginatedPaymentInstrumentsResponse.hasPrevious) && Objects.equals(this.paymentInstruments, paginatedPaymentInstrumentsResponse.paymentInstruments);
    }

    public int hashCode() {
        return Objects.hash(this.hasNext, this.hasPrevious, this.paymentInstruments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginatedPaymentInstrumentsResponse {\n");
        sb.append("    hasNext: ").append(this.toIndentedString(this.hasNext)).append("\n");
        sb.append("    hasPrevious: ").append(this.toIndentedString(this.hasPrevious)).append("\n");
        sb.append("    paymentInstruments: ").append(this.toIndentedString(this.paymentInstruments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaginatedPaymentInstrumentsResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaginatedPaymentInstrumentsResponse)JSON.getMapper().readValue(jsonString, PaginatedPaymentInstrumentsResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

