/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.TerminalProductPrice;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "id", "itemsIncluded", "name", "price"})
public class TerminalProduct {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ITEMS_INCLUDED = "itemsIncluded";
    private List<String> itemsIncluded = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRICE = "price";
    private TerminalProductPrice price;

    public TerminalProduct description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Information about items included and integration options.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public TerminalProduct id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the product.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TerminalProduct itemsIncluded(List<String> itemsIncluded) {
        this.itemsIncluded = itemsIncluded;
        return this;
    }

    public TerminalProduct addItemsIncludedItem(String itemsIncludedItem) {
        if (this.itemsIncluded == null) {
            this.itemsIncluded = new ArrayList<String>();
        }
        this.itemsIncluded.add(itemsIncludedItem);
        return this;
    }

    @ApiModelProperty(value="A list of parts included in the terminal package.")
    @JsonProperty(value="itemsIncluded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getItemsIncluded() {
        return this.itemsIncluded;
    }

    @JsonProperty(value="itemsIncluded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemsIncluded(List<String> itemsIncluded) {
        this.itemsIncluded = itemsIncluded;
    }

    public TerminalProduct name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The descriptive name of the product.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TerminalProduct price(TerminalProductPrice price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TerminalProductPrice getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(TerminalProductPrice price) {
        this.price = price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalProduct terminalProduct = (TerminalProduct)o;
        return Objects.equals(this.description, terminalProduct.description) && Objects.equals(this.id, terminalProduct.id) && Objects.equals(this.itemsIncluded, terminalProduct.itemsIncluded) && Objects.equals(this.name, terminalProduct.name) && Objects.equals(this.price, terminalProduct.price);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.itemsIncluded, this.name, this.price);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalProduct {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    itemsIncluded: ").append(this.toIndentedString(this.itemsIncluded)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TerminalProduct fromJson(String jsonString) throws JsonProcessingException {
        return (TerminalProduct)JSON.getMapper().readValue(jsonString, TerminalProduct.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

