/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Device;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.Link;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "itemsTotal", "link", "pagesTotal"})
public class SearchRegisteredDevicesResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<Device> data = null;
    public static final String JSON_PROPERTY_ITEMS_TOTAL = "itemsTotal";
    private Integer itemsTotal;
    public static final String JSON_PROPERTY_LINK = "link";
    private Link link;
    public static final String JSON_PROPERTY_PAGES_TOTAL = "pagesTotal";
    private Integer pagesTotal;

    public SearchRegisteredDevicesResponse data(List<Device> data) {
        this.data = data;
        return this;
    }

    public SearchRegisteredDevicesResponse addDataItem(Device dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Device>();
        }
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(value="Contains a list of registered SCA devices and their corresponding details.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Device> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(List<Device> data) {
        this.data = data;
    }

    public SearchRegisteredDevicesResponse itemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
        return this;
    }

    @ApiModelProperty(value="The total amount of registered SCA devices that match the query parameters.")
    @JsonProperty(value="itemsTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getItemsTotal() {
        return this.itemsTotal;
    }

    @JsonProperty(value="itemsTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
    }

    public SearchRegisteredDevicesResponse link(Link link) {
        this.link = link;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="link")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Link getLink() {
        return this.link;
    }

    @JsonProperty(value="link")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLink(Link link) {
        this.link = link;
    }

    public SearchRegisteredDevicesResponse pagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
        return this;
    }

    @ApiModelProperty(value="The total amount of list pages.")
    @JsonProperty(value="pagesTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPagesTotal() {
        return this.pagesTotal;
    }

    @JsonProperty(value="pagesTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRegisteredDevicesResponse searchRegisteredDevicesResponse = (SearchRegisteredDevicesResponse)o;
        return Objects.equals(this.data, searchRegisteredDevicesResponse.data) && Objects.equals(this.itemsTotal, searchRegisteredDevicesResponse.itemsTotal) && Objects.equals(this.link, searchRegisteredDevicesResponse.link) && Objects.equals(this.pagesTotal, searchRegisteredDevicesResponse.pagesTotal);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.itemsTotal, this.link, this.pagesTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchRegisteredDevicesResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    itemsTotal: ").append(this.toIndentedString(this.itemsTotal)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    pagesTotal: ").append(this.toIndentedString(this.pagesTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SearchRegisteredDevicesResponse fromJson(String jsonString) throws JsonProcessingException {
        return (SearchRegisteredDevicesResponse)JSON.getMapper().readValue(jsonString, SearchRegisteredDevicesResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

