/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayconfiguration;

import com.adyen.model.marketpayconfiguration.ErrorFieldType;
import com.adyen.model.marketpayconfiguration.JSON;
import com.adyen.model.marketpayconfiguration.NotificationConfigurationDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"configurations", "invalidFields", "pspReference", "resultCode"})
public class GetNotificationConfigurationListResponse {
    public static final String JSON_PROPERTY_CONFIGURATIONS = "configurations";
    private List<NotificationConfigurationDetails> configurations = null;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private String resultCode;

    public GetNotificationConfigurationListResponse configurations(List<NotificationConfigurationDetails> configurations) {
        this.configurations = configurations;
        return this;
    }

    public GetNotificationConfigurationListResponse addConfigurationsItem(NotificationConfigurationDetails configurationsItem) {
        if (this.configurations == null) {
            this.configurations = new ArrayList<NotificationConfigurationDetails>();
        }
        this.configurations.add(configurationsItem);
        return this;
    }

    @ApiModelProperty(value="Details of the notification subscription configurations.")
    @JsonProperty(value="configurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NotificationConfigurationDetails> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="configurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurations(List<NotificationConfigurationDetails> configurations) {
        this.configurations = configurations;
    }

    public GetNotificationConfigurationListResponse invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public GetNotificationConfigurationListResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Contains field validation errors that would prevent requests from being processed.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public GetNotificationConfigurationListResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The reference of a request. Can be used to uniquely identify the request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public GetNotificationConfigurationListResponse resultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result code.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetNotificationConfigurationListResponse getNotificationConfigurationListResponse = (GetNotificationConfigurationListResponse)o;
        return Objects.equals(this.configurations, getNotificationConfigurationListResponse.configurations) && Objects.equals(this.invalidFields, getNotificationConfigurationListResponse.invalidFields) && Objects.equals(this.pspReference, getNotificationConfigurationListResponse.pspReference) && Objects.equals(this.resultCode, getNotificationConfigurationListResponse.resultCode);
    }

    public int hashCode() {
        return Objects.hash(this.configurations, this.invalidFields, this.pspReference, this.resultCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetNotificationConfigurationListResponse {\n");
        sb.append("    configurations: ").append(this.toIndentedString(this.configurations)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString(this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetNotificationConfigurationListResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GetNotificationConfigurationListResponse)JSON.getMapper().readValue(jsonString, GetNotificationConfigurationListResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

