/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"authorisationToken", "paymentData", "paymentMethodType", "subtype", "token", "type", "url"})
public class CheckoutThreeDS2Action {
    public static final String JSON_PROPERTY_AUTHORISATION_TOKEN = "authorisationToken";
    private String authorisationToken;
    public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
    private String paymentData;
    public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
    private String paymentMethodType;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    private String subtype;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public CheckoutThreeDS2Action authorisationToken(String authorisationToken) {
        this.authorisationToken = authorisationToken;
        return this;
    }

    @ApiModelProperty(value="A token needed to authorise a payment.")
    @JsonProperty(value="authorisationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorisationToken() {
        return this.authorisationToken;
    }

    @JsonProperty(value="authorisationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorisationToken(String authorisationToken) {
        this.authorisationToken = authorisationToken;
    }

    public CheckoutThreeDS2Action paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @ApiModelProperty(value="Encoded payment data.")
    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentData() {
        return this.paymentData;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public CheckoutThreeDS2Action paymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @ApiModelProperty(value="Specifies the payment method.")
    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public CheckoutThreeDS2Action subtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    @ApiModelProperty(value="A subtype of the token.")
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubtype() {
        return this.subtype;
    }

    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public CheckoutThreeDS2Action token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="A token to pass to the 3DS2 Component to get the fingerprint.")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    public CheckoutThreeDS2Action type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**threeDS2**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CheckoutThreeDS2Action url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Specifies the URL to redirect to.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutThreeDS2Action checkoutThreeDS2Action = (CheckoutThreeDS2Action)o;
        return Objects.equals(this.authorisationToken, checkoutThreeDS2Action.authorisationToken) && Objects.equals(this.paymentData, checkoutThreeDS2Action.paymentData) && Objects.equals(this.paymentMethodType, checkoutThreeDS2Action.paymentMethodType) && Objects.equals(this.subtype, checkoutThreeDS2Action.subtype) && Objects.equals(this.token, checkoutThreeDS2Action.token) && Objects.equals((Object)this.type, (Object)checkoutThreeDS2Action.type) && Objects.equals(this.url, checkoutThreeDS2Action.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorisationToken, this.paymentData, this.paymentMethodType, this.subtype, this.token, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutThreeDS2Action {\n");
        sb.append("    authorisationToken: ").append(this.toIndentedString(this.authorisationToken)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString(this.paymentMethodType)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CheckoutThreeDS2Action fromJson(String jsonString) throws JsonProcessingException {
        return (CheckoutThreeDS2Action)JSON.getMapper().readValue(jsonString, CheckoutThreeDS2Action.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        THREEDS2("threeDS2");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

