/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "payoutMethodCodes"})
public class DeletePayoutMethodRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODES = "payoutMethodCodes";
    private List<String> payoutMethodCodes = new ArrayList<String>();

    public DeletePayoutMethodRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder, from which to delete the payout methods.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public DeletePayoutMethodRequest payoutMethodCodes(List<String> payoutMethodCodes) {
        this.payoutMethodCodes = payoutMethodCodes;
        return this;
    }

    public DeletePayoutMethodRequest addPayoutMethodCodesItem(String payoutMethodCodesItem) {
        this.payoutMethodCodes.add(payoutMethodCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The codes of the payout methods to be deleted.")
    @JsonProperty(value="payoutMethodCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPayoutMethodCodes() {
        return this.payoutMethodCodes;
    }

    @JsonProperty(value="payoutMethodCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCodes(List<String> payoutMethodCodes) {
        this.payoutMethodCodes = payoutMethodCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletePayoutMethodRequest deletePayoutMethodRequest = (DeletePayoutMethodRequest)o;
        return Objects.equals(this.accountHolderCode, deletePayoutMethodRequest.accountHolderCode) && Objects.equals(this.payoutMethodCodes, deletePayoutMethodRequest.payoutMethodCodes);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.payoutMethodCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeletePayoutMethodRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    payoutMethodCodes: ").append(this.toIndentedString(this.payoutMethodCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DeletePayoutMethodRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DeletePayoutMethodRequest)JSON.getMapper().readValue(jsonString, DeletePayoutMethodRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

