/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"balancePlatform", "description", "properties", "reference", "txVariant"})
public class PaymentInstrumentGroupInfo {
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, String> properties = null;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_TX_VARIANT = "txVariant";
    private String txVariant;

    public PaymentInstrumentGroupInfo balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [balance platform](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balancePlatforms/{id}__queryParam_id) to which the payment instrument group belongs.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public PaymentInstrumentGroupInfo description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the payment instrument group.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentInstrumentGroupInfo properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public PaymentInstrumentGroupInfo putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Properties of the payment instrument group.")
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public PaymentInstrumentGroupInfo reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment instrument group.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInstrumentGroupInfo txVariant(String txVariant) {
        this.txVariant = txVariant;
        return this;
    }

    @ApiModelProperty(required=true, value="The tx variant of the payment instrument group.")
    @JsonProperty(value="txVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxVariant() {
        return this.txVariant;
    }

    @JsonProperty(value="txVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTxVariant(String txVariant) {
        this.txVariant = txVariant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstrumentGroupInfo paymentInstrumentGroupInfo = (PaymentInstrumentGroupInfo)o;
        return Objects.equals(this.balancePlatform, paymentInstrumentGroupInfo.balancePlatform) && Objects.equals(this.description, paymentInstrumentGroupInfo.description) && Objects.equals(this.properties, paymentInstrumentGroupInfo.properties) && Objects.equals(this.reference, paymentInstrumentGroupInfo.reference) && Objects.equals(this.txVariant, paymentInstrumentGroupInfo.txVariant);
    }

    public int hashCode() {
        return Objects.hash(this.balancePlatform, this.description, this.properties, this.reference, this.txVariant);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstrumentGroupInfo {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    txVariant: ").append(this.toIndentedString(this.txVariant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentInstrumentGroupInfo fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentInstrumentGroupInfo)JSON.getMapper().readValue(jsonString, PaymentInstrumentGroupInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

