/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.Logo;
import com.adyen.model.management.TerminalSettings;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalSettingsMerchantLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public TerminalSettingsMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public TerminalSettingsMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public Logo getTerminalLogo(String merchantId, String model) throws ApiException, IOException {
        return this.getTerminalLogo(merchantId, model, null);
    }

    public Logo getTerminalLogo(String merchantId, String model, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings getTerminalSettings(String merchantId) throws ApiException, IOException {
        return this.getTerminalSettings(merchantId, null);
    }

    public TerminalSettings getTerminalSettings(String merchantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public Logo updateTerminalLogo(String merchantId, String model, Logo logo) throws ApiException, IOException {
        return this.updateTerminalLogo(merchantId, model, logo, null);
    }

    public Logo updateTerminalLogo(String merchantId, String model, Logo logo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = logo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings updateTerminalSettings(String merchantId, TerminalSettings terminalSettings) throws ApiException, IOException {
        return this.updateTerminalSettings(merchantId, terminalSettings, null);
    }

    public TerminalSettings updateTerminalSettings(String merchantId, TerminalSettings terminalSettings, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = terminalSettings.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }
}

