/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"excludeEventCodes", "includeEventCodes", "properties"})
public class AdditionalSettingsResponse {
    public static final String JSON_PROPERTY_EXCLUDE_EVENT_CODES = "excludeEventCodes";
    private List<String> excludeEventCodes = null;
    public static final String JSON_PROPERTY_INCLUDE_EVENT_CODES = "includeEventCodes";
    private List<String> includeEventCodes = null;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, Boolean> properties = null;

    public AdditionalSettingsResponse excludeEventCodes(List<String> excludeEventCodes) {
        this.excludeEventCodes = excludeEventCodes;
        return this;
    }

    public AdditionalSettingsResponse addExcludeEventCodesItem(String excludeEventCodesItem) {
        if (this.excludeEventCodes == null) {
            this.excludeEventCodes = new ArrayList<String>();
        }
        this.excludeEventCodes.add(excludeEventCodesItem);
        return this;
    }

    @ApiModelProperty(value="Object containing list of event codes for which the notifcation will not be sent. ")
    @JsonProperty(value="excludeEventCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExcludeEventCodes() {
        return this.excludeEventCodes;
    }

    @JsonProperty(value="excludeEventCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeEventCodes(List<String> excludeEventCodes) {
        this.excludeEventCodes = excludeEventCodes;
    }

    public AdditionalSettingsResponse includeEventCodes(List<String> includeEventCodes) {
        this.includeEventCodes = includeEventCodes;
        return this;
    }

    public AdditionalSettingsResponse addIncludeEventCodesItem(String includeEventCodesItem) {
        if (this.includeEventCodes == null) {
            this.includeEventCodes = new ArrayList<String>();
        }
        this.includeEventCodes.add(includeEventCodesItem);
        return this;
    }

    @ApiModelProperty(value="Object containing list of event codes for which the notifcation will be sent. ")
    @JsonProperty(value="includeEventCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIncludeEventCodes() {
        return this.includeEventCodes;
    }

    @JsonProperty(value="includeEventCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeEventCodes(List<String> includeEventCodes) {
        this.includeEventCodes = includeEventCodes;
    }

    public AdditionalSettingsResponse properties(Map<String, Boolean> properties) {
        this.properties = properties;
        return this;
    }

    public AdditionalSettingsResponse putPropertiesItem(String key, Boolean propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Boolean>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Object containing boolean key-value pairs. The key can be any [standard webhook additional setting](https://docs.adyen.com/development-resources/webhooks/additional-settings), and the value indicates if the setting is enabled. For example, `captureDelayHours`: **true** means the standard notifications you get will contain the number of hours remaining until the payment will be captured.")
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Boolean> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, Boolean> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalSettingsResponse additionalSettingsResponse = (AdditionalSettingsResponse)o;
        return Objects.equals(this.excludeEventCodes, additionalSettingsResponse.excludeEventCodes) && Objects.equals(this.includeEventCodes, additionalSettingsResponse.includeEventCodes) && Objects.equals(this.properties, additionalSettingsResponse.properties);
    }

    public int hashCode() {
        return Objects.hash(this.excludeEventCodes, this.includeEventCodes, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalSettingsResponse {\n");
        sb.append("    excludeEventCodes: ").append(this.toIndentedString(this.excludeEventCodes)).append("\n");
        sb.append("    includeEventCodes: ").append(this.toIndentedString(this.includeEventCodes)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AdditionalSettingsResponse fromJson(String jsonString) throws JsonProcessingException {
        return (AdditionalSettingsResponse)JSON.getMapper().readValue(jsonString, AdditionalSettingsResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

