/*
 * Decompiled with CFR 0.152.
 */
package com.adyen;

import com.adyen.Client;
import com.adyen.Config;
import com.adyen.enums.Environment;

public class Service {
    private boolean isApiKeyRequired = false;
    private Client client;

    protected Service(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public boolean isApiKeyRequired() {
        return this.isApiKeyRequired;
    }

    public void setApiKeyRequired(boolean apiKeyRequired) {
        this.isApiKeyRequired = apiKeyRequired;
    }

    protected String createBaseURL(String url) {
        Config config = this.getClient().getConfig();
        if (config.getEnvironment() != Environment.LIVE) {
            return url.replaceFirst("-live", "-test");
        }
        if (url.contains("pal-")) {
            if (config.getLiveEndpointUrlPrefix() == null) {
                throw new IllegalArgumentException("please provide a live url prefix in the client");
            }
            url = url.replaceFirst("https://pal-test.adyen.com/pal/servlet/", "https://" + config.getLiveEndpointUrlPrefix() + "-pal-live.adyenpayments.com/pal/servlet/");
        }
        if (url.contains("checkout-")) {
            if (config.getLiveEndpointUrlPrefix() == null) {
                throw new IllegalArgumentException("please provide a live url prefix in the client");
            }
            url = url.replaceFirst("https://checkout-test.adyen.com/", "https://" + config.getLiveEndpointUrlPrefix() + "-checkout-live.adyenpayments.com/checkout/");
        }
        return url.replaceFirst("-test", "-live");
    }
}

