/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.BankAccountDetail;
import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "bankAccountDetail", "captureMerchantReference", "capturePspReference", "creationDate", "description", "destinationAccountCode", "disputePspReference", "disputeReasonCode", "merchantReference", "paymentPspReference", "payoutPspReference", "pspReference", "sourceAccountCode", "transactionStatus", "transferCode"})
public class Transaction {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_DETAIL = "bankAccountDetail";
    private BankAccountDetail bankAccountDetail;
    public static final String JSON_PROPERTY_CAPTURE_MERCHANT_REFERENCE = "captureMerchantReference";
    private String captureMerchantReference;
    public static final String JSON_PROPERTY_CAPTURE_PSP_REFERENCE = "capturePspReference";
    private String capturePspReference;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
    private String destinationAccountCode;
    public static final String JSON_PROPERTY_DISPUTE_PSP_REFERENCE = "disputePspReference";
    private String disputePspReference;
    public static final String JSON_PROPERTY_DISPUTE_REASON_CODE = "disputeReasonCode";
    private String disputeReasonCode;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_PAYMENT_PSP_REFERENCE = "paymentPspReference";
    private String paymentPspReference;
    public static final String JSON_PROPERTY_PAYOUT_PSP_REFERENCE = "payoutPspReference";
    private String payoutPspReference;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
    private String sourceAccountCode;
    public static final String JSON_PROPERTY_TRANSACTION_STATUS = "transactionStatus";
    private TransactionStatusEnum transactionStatus;
    public static final String JSON_PROPERTY_TRANSFER_CODE = "transferCode";
    private String transferCode;

    public Transaction amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Transaction bankAccountDetail(BankAccountDetail bankAccountDetail) {
        this.bankAccountDetail = bankAccountDetail;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccountDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccountDetail getBankAccountDetail() {
        return this.bankAccountDetail;
    }

    @JsonProperty(value="bankAccountDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountDetail(BankAccountDetail bankAccountDetail) {
        this.bankAccountDetail = bankAccountDetail;
    }

    public Transaction captureMerchantReference(String captureMerchantReference) {
        this.captureMerchantReference = captureMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The merchant reference of a related capture.")
    @JsonProperty(value="captureMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCaptureMerchantReference() {
        return this.captureMerchantReference;
    }

    @JsonProperty(value="captureMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureMerchantReference(String captureMerchantReference) {
        this.captureMerchantReference = captureMerchantReference;
    }

    public Transaction capturePspReference(String capturePspReference) {
        this.capturePspReference = capturePspReference;
        return this;
    }

    @ApiModelProperty(value="The psp reference of a related capture.")
    @JsonProperty(value="capturePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCapturePspReference() {
        return this.capturePspReference;
    }

    @JsonProperty(value="capturePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapturePspReference(String capturePspReference) {
        this.capturePspReference = capturePspReference;
    }

    public Transaction creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date on which the transaction was performed.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public Transaction description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the transaction.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Transaction destinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account to which funds were credited during an outgoing fund transfer.")
    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountCode() {
        return this.destinationAccountCode;
    }

    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
    }

    public Transaction disputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
        return this;
    }

    @ApiModelProperty(value="The psp reference of the related dispute.")
    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisputePspReference() {
        return this.disputePspReference;
    }

    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
    }

    public Transaction disputeReasonCode(String disputeReasonCode) {
        this.disputeReasonCode = disputeReasonCode;
        return this;
    }

    @ApiModelProperty(value="The reason code of a dispute.")
    @JsonProperty(value="disputeReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisputeReasonCode() {
        return this.disputeReasonCode;
    }

    @JsonProperty(value="disputeReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisputeReasonCode(String disputeReasonCode) {
        this.disputeReasonCode = disputeReasonCode;
    }

    public Transaction merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The merchant reference of a transaction.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public Transaction paymentPspReference(String paymentPspReference) {
        this.paymentPspReference = paymentPspReference;
        return this;
    }

    @ApiModelProperty(value="The psp reference of the related authorisation or transfer.")
    @JsonProperty(value="paymentPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentPspReference() {
        return this.paymentPspReference;
    }

    @JsonProperty(value="paymentPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentPspReference(String paymentPspReference) {
        this.paymentPspReference = paymentPspReference;
    }

    public Transaction payoutPspReference(String payoutPspReference) {
        this.payoutPspReference = payoutPspReference;
        return this;
    }

    @ApiModelProperty(value="The psp reference of the related payout.")
    @JsonProperty(value="payoutPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutPspReference() {
        return this.payoutPspReference;
    }

    @JsonProperty(value="payoutPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutPspReference(String payoutPspReference) {
        this.payoutPspReference = payoutPspReference;
    }

    public Transaction pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The psp reference of a transaction.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public Transaction sourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account from which funds were debited during an incoming fund transfer.")
    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountCode() {
        return this.sourceAccountCode;
    }

    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
    }

    public Transaction transactionStatus(TransactionStatusEnum transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the transaction. >Permitted values: `PendingCredit`, `CreditFailed`, `CreditClosed`, `CreditSuspended`, `Credited`, `Converted`, `PendingDebit`, `DebitFailed`, `Debited`, `DebitReversedReceived`, `DebitedReversed`, `ChargebackReceived`, `Chargeback`, `ChargebackReversedReceived`, `ChargebackReversed`, `Payout`, `PayoutReversed`, `FundTransfer`, `PendingFundTransfer`, `ManualCorrected`.")
    @JsonProperty(value="transactionStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionStatusEnum getTransactionStatus() {
        return this.transactionStatus;
    }

    @JsonProperty(value="transactionStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionStatus(TransactionStatusEnum transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public Transaction transferCode(String transferCode) {
        this.transferCode = transferCode;
        return this;
    }

    @ApiModelProperty(value="The transfer code of the transaction.")
    @JsonProperty(value="transferCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferCode() {
        return this.transferCode;
    }

    @JsonProperty(value="transferCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferCode(String transferCode) {
        this.transferCode = transferCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.amount, transaction.amount) && Objects.equals(this.bankAccountDetail, transaction.bankAccountDetail) && Objects.equals(this.captureMerchantReference, transaction.captureMerchantReference) && Objects.equals(this.capturePspReference, transaction.capturePspReference) && Objects.equals(this.creationDate, transaction.creationDate) && Objects.equals(this.description, transaction.description) && Objects.equals(this.destinationAccountCode, transaction.destinationAccountCode) && Objects.equals(this.disputePspReference, transaction.disputePspReference) && Objects.equals(this.disputeReasonCode, transaction.disputeReasonCode) && Objects.equals(this.merchantReference, transaction.merchantReference) && Objects.equals(this.paymentPspReference, transaction.paymentPspReference) && Objects.equals(this.payoutPspReference, transaction.payoutPspReference) && Objects.equals(this.pspReference, transaction.pspReference) && Objects.equals(this.sourceAccountCode, transaction.sourceAccountCode) && Objects.equals((Object)this.transactionStatus, (Object)transaction.transactionStatus) && Objects.equals(this.transferCode, transaction.transferCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.bankAccountDetail, this.captureMerchantReference, this.capturePspReference, this.creationDate, this.description, this.destinationAccountCode, this.disputePspReference, this.disputeReasonCode, this.merchantReference, this.paymentPspReference, this.payoutPspReference, this.pspReference, this.sourceAccountCode, this.transactionStatus, this.transferCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    bankAccountDetail: ").append(this.toIndentedString(this.bankAccountDetail)).append("\n");
        sb.append("    captureMerchantReference: ").append(this.toIndentedString(this.captureMerchantReference)).append("\n");
        sb.append("    capturePspReference: ").append(this.toIndentedString(this.capturePspReference)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    destinationAccountCode: ").append(this.toIndentedString(this.destinationAccountCode)).append("\n");
        sb.append("    disputePspReference: ").append(this.toIndentedString(this.disputePspReference)).append("\n");
        sb.append("    disputeReasonCode: ").append(this.toIndentedString(this.disputeReasonCode)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    paymentPspReference: ").append(this.toIndentedString(this.paymentPspReference)).append("\n");
        sb.append("    payoutPspReference: ").append(this.toIndentedString(this.payoutPspReference)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    sourceAccountCode: ").append(this.toIndentedString(this.sourceAccountCode)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("    transferCode: ").append(this.toIndentedString(this.transferCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Transaction fromJson(String jsonString) throws JsonProcessingException {
        return (Transaction)JSON.getMapper().readValue(jsonString, Transaction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TransactionStatusEnum {
        BALANCENOTPAIDOUTTRANSFER("BalanceNotPaidOutTransfer"),
        BALANCEPLATFORMSWEEP("BalancePlatformSweep"),
        BALANCEPLATFORMSWEEPRETURNED("BalancePlatformSweepReturned"),
        CHARGEBACK("Chargeback"),
        CHARGEBACKCORRECTION("ChargebackCorrection"),
        CHARGEBACKCORRECTIONRECEIVED("ChargebackCorrectionReceived"),
        CHARGEBACKRECEIVED("ChargebackReceived"),
        CHARGEBACKREVERSED("ChargebackReversed"),
        CHARGEBACKREVERSEDCORRECTION("ChargebackReversedCorrection"),
        CHARGEBACKREVERSEDCORRECTIONRECEIVED("ChargebackReversedCorrectionReceived"),
        CHARGEBACKREVERSEDRECEIVED("ChargebackReversedReceived"),
        CONVERTED("Converted"),
        CREDITCLOSED("CreditClosed"),
        CREDITFAILED("CreditFailed"),
        CREDITREVERSED("CreditReversed"),
        CREDITREVERSEDRECEIVED("CreditReversedReceived"),
        CREDITSUSPENDED("CreditSuspended"),
        CREDITED("Credited"),
        DEBITFAILED("DebitFailed"),
        DEBITREVERSEDRECEIVED("DebitReversedReceived"),
        DEBITED("Debited"),
        DEBITEDREVERSED("DebitedReversed"),
        DEPOSITCORRECTIONCREDITED("DepositCorrectionCredited"),
        DEPOSITCORRECTIONDEBITED("DepositCorrectionDebited"),
        FEE("Fee"),
        FUNDTRANSFER("FundTransfer"),
        FUNDTRANSFERREVERSED("FundTransferReversed"),
        INVOICEDEDUCTIONCREDITED("InvoiceDeductionCredited"),
        INVOICEDEDUCTIONDEBITED("InvoiceDeductionDebited"),
        MANUALCORRECTED("ManualCorrected"),
        MANUALCORRECTIONCREDITED("ManualCorrectionCredited"),
        MANUALCORRECTIONDEBITED("ManualCorrectionDebited"),
        MERCHANTPAYIN("MerchantPayin"),
        MERCHANTPAYINREVERSED("MerchantPayinReversed"),
        PAYOUT("Payout"),
        PAYOUTREVERSED("PayoutReversed"),
        PENDINGCREDIT("PendingCredit"),
        PENDINGDEBIT("PendingDebit"),
        PENDINGFUNDTRANSFER("PendingFundTransfer"),
        RECREDITED("ReCredited"),
        RECREDITEDRECEIVED("ReCreditedReceived"),
        SECONDCHARGEBACK("SecondChargeback"),
        SECONDCHARGEBACKCORRECTION("SecondChargebackCorrection"),
        SECONDCHARGEBACKCORRECTIONRECEIVED("SecondChargebackCorrectionReceived"),
        SECONDCHARGEBACKRECEIVED("SecondChargebackReceived");

        private String value;

        private TransactionStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransactionStatusEnum fromValue(String value) {
            for (TransactionStatusEnum b : TransactionStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

