/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Item;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.SubInputDetail;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"configuration", "details", "inputDetails", "itemSearchUrl", "items", "key", "optional", "type", "value"})
public class InputDetail {
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private Map<String, String> configuration = null;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private List<SubInputDetail> details = null;
    public static final String JSON_PROPERTY_INPUT_DETAILS = "inputDetails";
    @Deprecated
    private List<SubInputDetail> inputDetails = null;
    public static final String JSON_PROPERTY_ITEM_SEARCH_URL = "itemSearchUrl";
    private String itemSearchUrl;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<Item> items = null;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_OPTIONAL = "optional";
    private Boolean optional;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public InputDetail configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public InputDetail putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    @ApiModelProperty(value="Configuration parameters for the required input.")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public InputDetail details(List<SubInputDetail> details) {
        this.details = details;
        return this;
    }

    public InputDetail addDetailsItem(SubInputDetail detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<SubInputDetail>();
        }
        this.details.add(detailsItem);
        return this;
    }

    @ApiModelProperty(value="Input details can also be provided recursively.")
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubInputDetail> getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetails(List<SubInputDetail> details) {
        this.details = details;
    }

    @Deprecated
    public InputDetail inputDetails(List<SubInputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        return this;
    }

    public InputDetail addInputDetailsItem(SubInputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<SubInputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Input details can also be provided recursively (deprecated).")
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubInputDetail> getInputDetails() {
        return this.inputDetails;
    }

    @Deprecated
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputDetails(List<SubInputDetail> inputDetails) {
        this.inputDetails = inputDetails;
    }

    public InputDetail itemSearchUrl(String itemSearchUrl) {
        this.itemSearchUrl = itemSearchUrl;
        return this;
    }

    @ApiModelProperty(value="In case of a select, the URL from which to query the items.")
    @JsonProperty(value="itemSearchUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getItemSearchUrl() {
        return this.itemSearchUrl;
    }

    @JsonProperty(value="itemSearchUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemSearchUrl(String itemSearchUrl) {
        this.itemSearchUrl = itemSearchUrl;
    }

    public InputDetail items(List<Item> items) {
        this.items = items;
        return this;
    }

    public InputDetail addItemsItem(Item itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="In case of a select, the items to choose from.")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Item> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItems(List<Item> items) {
        this.items = items;
    }

    public InputDetail key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The value to provide in the result.")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKey(String key) {
        this.key = key;
    }

    public InputDetail optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @ApiModelProperty(value="True if this input value is optional.")
    @JsonProperty(value="optional")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOptional() {
        return this.optional;
    }

    @JsonProperty(value="optional")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public InputDetail type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the required input.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public InputDetail value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The value can be pre-filled, if available.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputDetail inputDetail = (InputDetail)o;
        return Objects.equals(this.configuration, inputDetail.configuration) && Objects.equals(this.details, inputDetail.details) && Objects.equals(this.inputDetails, inputDetail.inputDetails) && Objects.equals(this.itemSearchUrl, inputDetail.itemSearchUrl) && Objects.equals(this.items, inputDetail.items) && Objects.equals(this.key, inputDetail.key) && Objects.equals(this.optional, inputDetail.optional) && Objects.equals(this.type, inputDetail.type) && Objects.equals(this.value, inputDetail.value);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.details, this.inputDetails, this.itemSearchUrl, this.items, this.key, this.optional, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputDetail {\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    inputDetails: ").append(this.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    itemSearchUrl: ").append(this.toIndentedString(this.itemSearchUrl)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static InputDetail fromJson(String jsonString) throws JsonProcessingException {
        return (InputDetail)JSON.getMapper().readValue(jsonString, InputDetail.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

