/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.MerchantAcquirerPair;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"operation", "value"})
public class MerchantsRestriction {
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private String operation;
    public static final String JSON_PROPERTY_VALUE = "value";
    private List<MerchantAcquirerPair> value = null;

    public MerchantsRestriction operation(String operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines how the condition must be evaluated.")
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public MerchantsRestriction value(List<MerchantAcquirerPair> value) {
        this.value = value;
        return this;
    }

    public MerchantsRestriction addValueItem(MerchantAcquirerPair valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<MerchantAcquirerPair>();
        }
        this.value.add(valueItem);
        return this;
    }

    @ApiModelProperty(value="List of merchant ID and acquirer ID pairs.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MerchantAcquirerPair> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(List<MerchantAcquirerPair> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantsRestriction merchantsRestriction = (MerchantsRestriction)o;
        return Objects.equals(this.operation, merchantsRestriction.operation) && Objects.equals(this.value, merchantsRestriction.value);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantsRestriction {\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MerchantsRestriction fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantsRestriction)JSON.getMapper().readValue(jsonString, MerchantsRestriction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

