/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.adyen.model.posterminalmanagement.Store;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"bluetoothIp", "bluetoothMac", "companyAccount", "country", "deviceModel", "dhcpEnabled", "displayLabel", "ethernetIp", "ethernetMac", "firmwareVersion", "iccid", "lastActivityDateTime", "lastTransactionDateTime", "linkNegotiation", "merchantAccount", "merchantInventory", "permanentTerminalId", "serialNumber", "simStatus", "store", "storeDetails", "terminal", "terminalStatus", "wifiIp", "wifiMac"})
public class GetTerminalDetailsResponse {
    public static final String JSON_PROPERTY_BLUETOOTH_IP = "bluetoothIp";
    private String bluetoothIp;
    public static final String JSON_PROPERTY_BLUETOOTH_MAC = "bluetoothMac";
    private String bluetoothMac;
    public static final String JSON_PROPERTY_COMPANY_ACCOUNT = "companyAccount";
    private String companyAccount;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_DEVICE_MODEL = "deviceModel";
    private String deviceModel;
    public static final String JSON_PROPERTY_DHCP_ENABLED = "dhcpEnabled";
    private Boolean dhcpEnabled;
    public static final String JSON_PROPERTY_DISPLAY_LABEL = "displayLabel";
    private String displayLabel;
    public static final String JSON_PROPERTY_ETHERNET_IP = "ethernetIp";
    private String ethernetIp;
    public static final String JSON_PROPERTY_ETHERNET_MAC = "ethernetMac";
    private String ethernetMac;
    public static final String JSON_PROPERTY_FIRMWARE_VERSION = "firmwareVersion";
    private String firmwareVersion;
    public static final String JSON_PROPERTY_ICCID = "iccid";
    private String iccid;
    public static final String JSON_PROPERTY_LAST_ACTIVITY_DATE_TIME = "lastActivityDateTime";
    private OffsetDateTime lastActivityDateTime;
    public static final String JSON_PROPERTY_LAST_TRANSACTION_DATE_TIME = "lastTransactionDateTime";
    private OffsetDateTime lastTransactionDateTime;
    public static final String JSON_PROPERTY_LINK_NEGOTIATION = "linkNegotiation";
    private String linkNegotiation;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_INVENTORY = "merchantInventory";
    private Boolean merchantInventory;
    public static final String JSON_PROPERTY_PERMANENT_TERMINAL_ID = "permanentTerminalId";
    private String permanentTerminalId;
    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber;
    public static final String JSON_PROPERTY_SIM_STATUS = "simStatus";
    private String simStatus;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_STORE_DETAILS = "storeDetails";
    private Store storeDetails;
    public static final String JSON_PROPERTY_TERMINAL = "terminal";
    private String terminal;
    public static final String JSON_PROPERTY_TERMINAL_STATUS = "terminalStatus";
    private TerminalStatusEnum terminalStatus;
    public static final String JSON_PROPERTY_WIFI_IP = "wifiIp";
    private String wifiIp;
    public static final String JSON_PROPERTY_WIFI_MAC = "wifiMac";
    private String wifiMac;

    public GetTerminalDetailsResponse bluetoothIp(String bluetoothIp) {
        this.bluetoothIp = bluetoothIp;
        return this;
    }

    @ApiModelProperty(value="The Bluetooth IP address of the terminal.")
    @JsonProperty(value="bluetoothIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBluetoothIp() {
        return this.bluetoothIp;
    }

    @JsonProperty(value="bluetoothIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBluetoothIp(String bluetoothIp) {
        this.bluetoothIp = bluetoothIp;
    }

    public GetTerminalDetailsResponse bluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
        return this;
    }

    @ApiModelProperty(value="The Bluetooth MAC address of the terminal.")
    @JsonProperty(value="bluetoothMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBluetoothMac() {
        return this.bluetoothMac;
    }

    @JsonProperty(value="bluetoothMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
    }

    public GetTerminalDetailsResponse companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The company account that the terminal is associated with. If this is the only account level shown in the response, the terminal is assigned to the inventory of the company account.")
    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public GetTerminalDetailsResponse country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The country where the terminal is used.")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public GetTerminalDetailsResponse deviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    @ApiModelProperty(value="The model name of the terminal.")
    @JsonProperty(value="deviceModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @JsonProperty(value="deviceModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public GetTerminalDetailsResponse dhcpEnabled(Boolean dhcpEnabled) {
        this.dhcpEnabled = dhcpEnabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether assigning IP addresses through a DHCP server is enabled on the terminal.")
    @JsonProperty(value="dhcpEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDhcpEnabled() {
        return this.dhcpEnabled;
    }

    @JsonProperty(value="dhcpEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDhcpEnabled(Boolean dhcpEnabled) {
        this.dhcpEnabled = dhcpEnabled;
    }

    public GetTerminalDetailsResponse displayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
        return this;
    }

    @ApiModelProperty(value="The label shown on the status bar of the display. This label (if any) is specified in your Customer Area.")
    @JsonProperty(value="displayLabel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayLabel() {
        return this.displayLabel;
    }

    @JsonProperty(value="displayLabel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public GetTerminalDetailsResponse ethernetIp(String ethernetIp) {
        this.ethernetIp = ethernetIp;
        return this;
    }

    @ApiModelProperty(value="The terminal's IP address in your Ethernet network.")
    @JsonProperty(value="ethernetIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEthernetIp() {
        return this.ethernetIp;
    }

    @JsonProperty(value="ethernetIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEthernetIp(String ethernetIp) {
        this.ethernetIp = ethernetIp;
    }

    public GetTerminalDetailsResponse ethernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
        return this;
    }

    @ApiModelProperty(value="The terminal's MAC address in your Ethernet network.")
    @JsonProperty(value="ethernetMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEthernetMac() {
        return this.ethernetMac;
    }

    @JsonProperty(value="ethernetMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEthernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
    }

    public GetTerminalDetailsResponse firmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        return this;
    }

    @ApiModelProperty(value="The software release currently in use on the terminal.")
    @JsonProperty(value="firmwareVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @JsonProperty(value="firmwareVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public GetTerminalDetailsResponse iccid(String iccid) {
        this.iccid = iccid;
        return this;
    }

    @ApiModelProperty(value="The integrated circuit card identifier (ICCID) of the SIM card in the terminal.")
    @JsonProperty(value="iccid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIccid() {
        return this.iccid;
    }

    @JsonProperty(value="iccid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public GetTerminalDetailsResponse lastActivityDateTime(OffsetDateTime lastActivityDateTime) {
        this.lastActivityDateTime = lastActivityDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.")
    @JsonProperty(value="lastActivityDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastActivityDateTime() {
        return this.lastActivityDateTime;
    }

    @JsonProperty(value="lastActivityDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastActivityDateTime(OffsetDateTime lastActivityDateTime) {
        this.lastActivityDateTime = lastActivityDateTime;
    }

    public GetTerminalDetailsResponse lastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
        this.lastTransactionDateTime = lastTransactionDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.")
    @JsonProperty(value="lastTransactionDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastTransactionDateTime() {
        return this.lastTransactionDateTime;
    }

    @JsonProperty(value="lastTransactionDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
        this.lastTransactionDateTime = lastTransactionDateTime;
    }

    public GetTerminalDetailsResponse linkNegotiation(String linkNegotiation) {
        this.linkNegotiation = linkNegotiation;
        return this;
    }

    @ApiModelProperty(value="The Ethernet link negotiation that the terminal uses:   - `auto`: Auto-negotiation  - `100full`: 100 Mbps full duplex")
    @JsonProperty(value="linkNegotiation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLinkNegotiation() {
        return this.linkNegotiation;
    }

    @JsonProperty(value="linkNegotiation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkNegotiation(String linkNegotiation) {
        this.linkNegotiation = linkNegotiation;
    }

    public GetTerminalDetailsResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account that the terminal is associated with. If the response doesn't contain a `store` the terminal is assigned to this merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public GetTerminalDetailsResponse merchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
        return this;
    }

    @ApiModelProperty(value="Boolean that indicates if the terminal is assigned to the merchant inventory. This is returned when the terminal is assigned to a merchant account.  - If **true**, this indicates that the terminal is in the merchant inventory. This also means that the terminal cannot be boarded.  - If **false**, this indicates that the terminal is assigned to the merchant account as an in-store terminal. This means that the terminal is ready to be boarded, or is already boarded.")
    @JsonProperty(value="merchantInventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMerchantInventory() {
        return this.merchantInventory;
    }

    @JsonProperty(value="merchantInventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
    }

    public GetTerminalDetailsResponse permanentTerminalId(String permanentTerminalId) {
        this.permanentTerminalId = permanentTerminalId;
        return this;
    }

    @ApiModelProperty(value="The permanent terminal ID.")
    @JsonProperty(value="permanentTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPermanentTerminalId() {
        return this.permanentTerminalId;
    }

    @JsonProperty(value="permanentTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermanentTerminalId(String permanentTerminalId) {
        this.permanentTerminalId = permanentTerminalId;
    }

    public GetTerminalDetailsResponse serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(value="The serial number of the terminal.")
    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public GetTerminalDetailsResponse simStatus(String simStatus) {
        this.simStatus = simStatus;
        return this;
    }

    @ApiModelProperty(value="On a terminal that supports 3G or 4G connectivity, indicates the status of the SIM card in the terminal: ACTIVE or INVENTORY.")
    @JsonProperty(value="simStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSimStatus() {
        return this.simStatus;
    }

    @JsonProperty(value="simStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSimStatus(String simStatus) {
        this.simStatus = simStatus;
    }

    public GetTerminalDetailsResponse store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The store code of the store that the terminal is assigned to.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public GetTerminalDetailsResponse storeDetails(Store storeDetails) {
        this.storeDetails = storeDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="storeDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Store getStoreDetails() {
        return this.storeDetails;
    }

    @JsonProperty(value="storeDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreDetails(Store storeDetails) {
        this.storeDetails = storeDetails;
    }

    public GetTerminalDetailsResponse terminal(String terminal) {
        this.terminal = terminal;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique terminal ID.")
    @JsonProperty(value="terminal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTerminal() {
        return this.terminal;
    }

    @JsonProperty(value="terminal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public GetTerminalDetailsResponse terminalStatus(TerminalStatusEnum terminalStatus) {
        this.terminalStatus = terminalStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the terminal:   - `OnlineToday`, `OnlineLast1Day`, `OnlineLast2Days` etcetera to `OnlineLast7Days`: Indicates when in the past week the terminal was last online.   - `SwitchedOff`: Indicates it was more than a week ago that the terminal was last online.   - `ReAssignToInventoryPending`, `ReAssignToStorePending`, `ReAssignToMerchantInventoryPending`: Indicates the terminal is scheduled to be reassigned.")
    @JsonProperty(value="terminalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TerminalStatusEnum getTerminalStatus() {
        return this.terminalStatus;
    }

    @JsonProperty(value="terminalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminalStatus(TerminalStatusEnum terminalStatus) {
        this.terminalStatus = terminalStatus;
    }

    public GetTerminalDetailsResponse wifiIp(String wifiIp) {
        this.wifiIp = wifiIp;
        return this;
    }

    @ApiModelProperty(value="The terminal's IP address in your Wi-Fi network.")
    @JsonProperty(value="wifiIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWifiIp() {
        return this.wifiIp;
    }

    @JsonProperty(value="wifiIp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWifiIp(String wifiIp) {
        this.wifiIp = wifiIp;
    }

    public GetTerminalDetailsResponse wifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
        return this;
    }

    @ApiModelProperty(value="The terminal's MAC address in your Wi-Fi network.")
    @JsonProperty(value="wifiMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWifiMac() {
        return this.wifiMac;
    }

    @JsonProperty(value="wifiMac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTerminalDetailsResponse getTerminalDetailsResponse = (GetTerminalDetailsResponse)o;
        return Objects.equals(this.bluetoothIp, getTerminalDetailsResponse.bluetoothIp) && Objects.equals(this.bluetoothMac, getTerminalDetailsResponse.bluetoothMac) && Objects.equals(this.companyAccount, getTerminalDetailsResponse.companyAccount) && Objects.equals(this.country, getTerminalDetailsResponse.country) && Objects.equals(this.deviceModel, getTerminalDetailsResponse.deviceModel) && Objects.equals(this.dhcpEnabled, getTerminalDetailsResponse.dhcpEnabled) && Objects.equals(this.displayLabel, getTerminalDetailsResponse.displayLabel) && Objects.equals(this.ethernetIp, getTerminalDetailsResponse.ethernetIp) && Objects.equals(this.ethernetMac, getTerminalDetailsResponse.ethernetMac) && Objects.equals(this.firmwareVersion, getTerminalDetailsResponse.firmwareVersion) && Objects.equals(this.iccid, getTerminalDetailsResponse.iccid) && Objects.equals(this.lastActivityDateTime, getTerminalDetailsResponse.lastActivityDateTime) && Objects.equals(this.lastTransactionDateTime, getTerminalDetailsResponse.lastTransactionDateTime) && Objects.equals(this.linkNegotiation, getTerminalDetailsResponse.linkNegotiation) && Objects.equals(this.merchantAccount, getTerminalDetailsResponse.merchantAccount) && Objects.equals(this.merchantInventory, getTerminalDetailsResponse.merchantInventory) && Objects.equals(this.permanentTerminalId, getTerminalDetailsResponse.permanentTerminalId) && Objects.equals(this.serialNumber, getTerminalDetailsResponse.serialNumber) && Objects.equals(this.simStatus, getTerminalDetailsResponse.simStatus) && Objects.equals(this.store, getTerminalDetailsResponse.store) && Objects.equals(this.storeDetails, getTerminalDetailsResponse.storeDetails) && Objects.equals(this.terminal, getTerminalDetailsResponse.terminal) && Objects.equals((Object)this.terminalStatus, (Object)getTerminalDetailsResponse.terminalStatus) && Objects.equals(this.wifiIp, getTerminalDetailsResponse.wifiIp) && Objects.equals(this.wifiMac, getTerminalDetailsResponse.wifiMac);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bluetoothIp, this.bluetoothMac, this.companyAccount, this.country, this.deviceModel, this.dhcpEnabled, this.displayLabel, this.ethernetIp, this.ethernetMac, this.firmwareVersion, this.iccid, this.lastActivityDateTime, this.lastTransactionDateTime, this.linkNegotiation, this.merchantAccount, this.merchantInventory, this.permanentTerminalId, this.serialNumber, this.simStatus, this.store, this.storeDetails, this.terminal, this.terminalStatus, this.wifiIp, this.wifiMac});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTerminalDetailsResponse {\n");
        sb.append("    bluetoothIp: ").append(this.toIndentedString(this.bluetoothIp)).append("\n");
        sb.append("    bluetoothMac: ").append(this.toIndentedString(this.bluetoothMac)).append("\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    deviceModel: ").append(this.toIndentedString(this.deviceModel)).append("\n");
        sb.append("    dhcpEnabled: ").append(this.toIndentedString(this.dhcpEnabled)).append("\n");
        sb.append("    displayLabel: ").append(this.toIndentedString(this.displayLabel)).append("\n");
        sb.append("    ethernetIp: ").append(this.toIndentedString(this.ethernetIp)).append("\n");
        sb.append("    ethernetMac: ").append(this.toIndentedString(this.ethernetMac)).append("\n");
        sb.append("    firmwareVersion: ").append(this.toIndentedString(this.firmwareVersion)).append("\n");
        sb.append("    iccid: ").append(this.toIndentedString(this.iccid)).append("\n");
        sb.append("    lastActivityDateTime: ").append(this.toIndentedString(this.lastActivityDateTime)).append("\n");
        sb.append("    lastTransactionDateTime: ").append(this.toIndentedString(this.lastTransactionDateTime)).append("\n");
        sb.append("    linkNegotiation: ").append(this.toIndentedString(this.linkNegotiation)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantInventory: ").append(this.toIndentedString(this.merchantInventory)).append("\n");
        sb.append("    permanentTerminalId: ").append(this.toIndentedString(this.permanentTerminalId)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    simStatus: ").append(this.toIndentedString(this.simStatus)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storeDetails: ").append(this.toIndentedString(this.storeDetails)).append("\n");
        sb.append("    terminal: ").append(this.toIndentedString(this.terminal)).append("\n");
        sb.append("    terminalStatus: ").append(this.toIndentedString((Object)this.terminalStatus)).append("\n");
        sb.append("    wifiIp: ").append(this.toIndentedString(this.wifiIp)).append("\n");
        sb.append("    wifiMac: ").append(this.toIndentedString(this.wifiMac)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetTerminalDetailsResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GetTerminalDetailsResponse)JSON.getMapper().readValue(jsonString, GetTerminalDetailsResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TerminalStatusEnum {
        ONLINELAST1DAY("OnlineLast1Day"),
        ONLINELAST2DAYS("OnlineLast2Days"),
        ONLINELAST3DAYS("OnlineLast3Days"),
        ONLINELAST4DAYS("OnlineLast4Days"),
        ONLINELAST5DAYS("OnlineLast5Days"),
        ONLINELAST6DAYS("OnlineLast6Days"),
        ONLINELAST7DAYS("OnlineLast7Days"),
        ONLINETODAY("OnlineToday"),
        REASSIGNTOINVENTORYPENDING("ReAssignToInventoryPending"),
        REASSIGNTOMERCHANTINVENTORYPENDING("ReAssignToMerchantInventoryPending"),
        REASSIGNTOSTOREPENDING("ReAssignToStorePending"),
        SWITCHEDOFF("SwitchedOff");

        private String value;

        private TerminalStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TerminalStatusEnum fromValue(String value) {
            for (TerminalStatusEnum b : TerminalStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

