/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.StoreSplitConfiguration;
import com.adyen.model.management.UpdatableAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "businessLineIds", "description", "externalReferenceId", "phoneNumber", "splitConfiguration", "status"})
public class UpdateStoreRequest {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private UpdatableAddress address;
    public static final String JSON_PROPERTY_BUSINESS_LINE_IDS = "businessLineIds";
    private List<String> businessLineIds = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EXTERNAL_REFERENCE_ID = "externalReferenceId";
    private String externalReferenceId;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_SPLIT_CONFIGURATION = "splitConfiguration";
    private StoreSplitConfiguration splitConfiguration;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public UpdateStoreRequest address(UpdatableAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpdatableAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(UpdatableAddress address) {
        this.address = address;
    }

    public UpdateStoreRequest businessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
        return this;
    }

    public UpdateStoreRequest addBusinessLineIdsItem(String businessLineIdsItem) {
        if (this.businessLineIds == null) {
            this.businessLineIds = new ArrayList<String>();
        }
        this.businessLineIds.add(businessLineIdsItem);
        return this;
    }

    @ApiModelProperty(value="The unique identifiers of the [business lines](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businessLines__resParam_id) that the store is associated with.")
    @JsonProperty(value="businessLineIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBusinessLineIds() {
        return this.businessLineIds;
    }

    @JsonProperty(value="businessLineIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
    }

    public UpdateStoreRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the store.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateStoreRequest externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store, used by certain payment methods and tax authorities.  Required for CNPJ in Brazil, in the format 00.000.000/0000-00 separated by dots, slashes, hyphens, or without separators.  Optional for SIRET in France, up to 14 digits.  Optional for Zip in Australia, up to 50 digits.  ")
    @JsonProperty(value="externalReferenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    @JsonProperty(value="externalReferenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public UpdateStoreRequest phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the store, including '+' and country code in the [E.164](https://en.wikipedia.org/wiki/E.164) format. If passed in a different format, we convert and validate the phone number against E.164. ")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public UpdateStoreRequest splitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="splitConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StoreSplitConfiguration getSplitConfiguration() {
        return this.splitConfiguration;
    }

    @JsonProperty(value="splitConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
    }

    public UpdateStoreRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the store. Possible values are:  - **active**: This value is assigned automatically when a store is created.  - **inactive**: The maximum [transaction limits and number of Store-and-Forward transactions](https://docs.adyen.com/point-of-sale/determine-account-structure/configure-features#payment-features) for the store are set to 0. This blocks new transactions, but captures are still possible. - **closed**: The terminals of the store are reassigned to the merchant inventory, so they can't process payments.  You can change the status from **active** to **inactive**, and from **inactive** to **active** or **closed**.  Once **closed**, a store can't be reopened.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateStoreRequest updateStoreRequest = (UpdateStoreRequest)o;
        return Objects.equals(this.address, updateStoreRequest.address) && Objects.equals(this.businessLineIds, updateStoreRequest.businessLineIds) && Objects.equals(this.description, updateStoreRequest.description) && Objects.equals(this.externalReferenceId, updateStoreRequest.externalReferenceId) && Objects.equals(this.phoneNumber, updateStoreRequest.phoneNumber) && Objects.equals(this.splitConfiguration, updateStoreRequest.splitConfiguration) && Objects.equals((Object)this.status, (Object)updateStoreRequest.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.businessLineIds, this.description, this.externalReferenceId, this.phoneNumber, this.splitConfiguration, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateStoreRequest {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    businessLineIds: ").append(this.toIndentedString(this.businessLineIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    splitConfiguration: ").append(this.toIndentedString(this.splitConfiguration)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateStoreRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateStoreRequest)JSON.getMapper().readValue(jsonString, UpdateStoreRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

