/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CounterpartyV3;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.PaymentInstrument;
import com.adyen.model.transfers.ResourceReference;
import com.adyen.model.transfers.TransferCategoryData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolder", "amount", "balanceAccount", "category", "categoryData", "counterparty", "creationDate", "description", "direction", "id", "paymentInstrument", "reason", "reference", "referenceForBeneficiary", "status", "type"})
public class Transfer {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private ResourceReference accountHolder;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT = "balanceAccount";
    private ResourceReference balanceAccount;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_CATEGORY_DATA = "categoryData";
    private TransferCategoryData categoryData;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private CounterpartyV3 counterparty;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT = "paymentInstrument";
    private PaymentInstrument paymentInstrument;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public Transfer accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public Transfer amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Transfer balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    public Transfer category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="The category of the transfer.  Possible values:   - **bank**: a transfer involving a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: a transfer between [balance accounts](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: a transfer initiated by an Adyen-issued card.  - **platformPayment**: funds movements related to payments that are acquired for your users.")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Transfer categoryData(TransferCategoryData categoryData) {
        this.categoryData = categoryData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="categoryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferCategoryData getCategoryData() {
        return this.categoryData;
    }

    @JsonProperty(value="categoryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategoryData(TransferCategoryData categoryData) {
        this.categoryData = categoryData;
    }

    public Transfer counterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CounterpartyV3 getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
    }

    public Transfer creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public Transfer description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Transfer direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="The direction of the transfer.  Possible values: **incoming**, **outgoing**.")
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public Transfer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Transfer paymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentInstrument getPaymentInstrument() {
        return this.paymentInstrument;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
    }

    public Transfer reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Additional information about the status of the transfer.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public Transfer reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public Transfer referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value=" A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**.The maximum length depends on the `category`.   - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.")
    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public Transfer status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The result of the transfer.   For example, **authorised**, **refused**, or **error**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Transfer type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of transfer or transaction. For example, **refund**, **payment**, **internalTransfer**, **bankTransfer**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transfer transfer = (Transfer)o;
        return Objects.equals(this.accountHolder, transfer.accountHolder) && Objects.equals(this.amount, transfer.amount) && Objects.equals(this.balanceAccount, transfer.balanceAccount) && Objects.equals((Object)this.category, (Object)transfer.category) && Objects.equals(this.categoryData, transfer.categoryData) && Objects.equals(this.counterparty, transfer.counterparty) && Objects.equals(this.creationDate, transfer.creationDate) && Objects.equals(this.description, transfer.description) && Objects.equals((Object)this.direction, (Object)transfer.direction) && Objects.equals(this.id, transfer.id) && Objects.equals(this.paymentInstrument, transfer.paymentInstrument) && Objects.equals((Object)this.reason, (Object)transfer.reason) && Objects.equals(this.reference, transfer.reference) && Objects.equals(this.referenceForBeneficiary, transfer.referenceForBeneficiary) && Objects.equals((Object)this.status, (Object)transfer.status) && Objects.equals((Object)this.type, (Object)transfer.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolder, this.amount, this.balanceAccount, this.category, this.categoryData, this.counterparty, this.creationDate, this.description, this.direction, this.id, this.paymentInstrument, this.reason, this.reference, this.referenceForBeneficiary, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transfer {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    categoryData: ").append(this.toIndentedString(this.categoryData)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrument: ").append(this.toIndentedString(this.paymentInstrument)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Transfer fromJson(String jsonString) throws JsonProcessingException {
        return (Transfer)JSON.getMapper().readValue(jsonString, Transfer.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSAL("atmWithdrawalReversal"),
        BALANCEADJUSTMENT("balanceAdjustment"),
        BALANCEMIGRATION("balanceMigration"),
        BALANCEROLLOVER("balanceRollover"),
        BANKDIRECTDEBIT("bankDirectDebit"),
        BANKTRANSFER("bankTransfer"),
        CAPITALFUNDSCOLLECTION("capitalFundsCollection"),
        CAPTURE("capture"),
        CAPTUREREVERSAL("captureReversal"),
        CARDTRANSFER("cardTransfer"),
        CASHOUTFEE("cashOutFee"),
        CASHOUTFUNDING("cashOutFunding"),
        CASHOUTINSTRUCTION("cashOutInstruction"),
        CHARGEBACK("chargeback"),
        CHARGEBACKCORRECTION("chargebackCorrection"),
        CHARGEBACKREVERSAL("chargebackReversal"),
        CHARGEBACKREVERSALCORRECTION("chargebackReversalCorrection"),
        DEPOSITCORRECTION("depositCorrection"),
        FEE("fee"),
        GRANT("grant"),
        INSTALLMENT("installment"),
        INSTALLMENTREVERSAL("installmentReversal"),
        INTERNALDIRECTDEBIT("internalDirectDebit"),
        INTERNALTRANSFER("internalTransfer"),
        INVOICEDEDUCTION("invoiceDeduction"),
        LEFTOVER("leftover"),
        MANUALCORRECTION("manualCorrection"),
        MISCCOST("miscCost"),
        PAYMENT("payment"),
        PAYMENTCOST("paymentCost"),
        REFUND("refund"),
        REFUNDREVERSAL("refundReversal"),
        REPAYMENT("repayment"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKCORRECTION("secondChargebackCorrection");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        APPROVALPENDING("approvalPending"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
        ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
        AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
        AUTHADJUSTMENTERROR("authAdjustmentError"),
        AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
        AUTHORISED("authorised"),
        BANKTRANSFER("bankTransfer"),
        BANKTRANSFERPENDING("bankTransferPending"),
        BOOKED("booked"),
        BOOKINGPENDING("bookingPending"),
        CANCELLED("cancelled"),
        CAPTUREPENDING("capturePending"),
        CAPTUREREVERSALPENDING("captureReversalPending"),
        CAPTUREREVERSED("captureReversed"),
        CAPTURED("captured"),
        CAPTUREDEXTERNALLY("capturedExternally"),
        CHARGEBACK("chargeback"),
        CHARGEBACKEXTERNALLY("chargebackExternally"),
        CHARGEBACKPENDING("chargebackPending"),
        CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
        CHARGEBACKREVERSED("chargebackReversed"),
        CREDITED("credited"),
        DEPOSITCORRECTION("depositCorrection"),
        DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
        DISPUTE("dispute"),
        DISPUTECLOSED("disputeClosed"),
        DISPUTEEXPIRED("disputeExpired"),
        DISPUTENEEDSREVIEW("disputeNeedsReview"),
        ERROR("error"),
        EXPIRED("expired"),
        FAILED("failed"),
        FEE("fee"),
        FEEPENDING("feePending"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALTRANSFERPENDING("internalTransferPending"),
        INVOICEDEDUCTION("invoiceDeduction"),
        INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
        MANUALCORRECTIONPENDING("manualCorrectionPending"),
        MANUALLYCORRECTED("manuallyCorrected"),
        MATCHEDSTATEMENT("matchedStatement"),
        MATCHEDSTATEMENTPENDING("matchedStatementPending"),
        MERCHANTPAYIN("merchantPayin"),
        MERCHANTPAYINPENDING("merchantPayinPending"),
        MERCHANTPAYINREVERSED("merchantPayinReversed"),
        MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
        MISCCOST("miscCost"),
        MISCCOSTPENDING("miscCostPending"),
        PAYMENTCOST("paymentCost"),
        PAYMENTCOSTPENDING("paymentCostPending"),
        RECEIVED("received"),
        REFUNDPENDING("refundPending"),
        REFUNDREVERSALPENDING("refundReversalPending"),
        REFUNDREVERSED("refundReversed"),
        REFUNDED("refunded"),
        REFUNDEDEXTERNALLY("refundedExternally"),
        REFUSED("refused"),
        REJECTED("rejected"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
        RETURNED("returned"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKPENDING("secondChargebackPending"),
        UNDEFINED("undefined");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        BALANCEACCOUNTTEMPORARILYBLOCKEDBYTRANSACTIONRULE("balanceAccountTemporarilyBlockedByTransactionRule"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        DECLINED("declined"),
        DECLINEDBYTRANSACTIONRULE("declinedByTransactionRule"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        PENDINGAPPROVAL("pendingApproval"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        SCAFAILED("scaFailed"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        BANK("bank"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

